/*
 Highcharts JS v9.3.0 (2021-10-21)

 Accessibility module

 (c) 2010-2021 Highsoft AS
 Author: Oystein Moseng

 License: www.highcharts.com/license
*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/accessibility",["highcharts"],function(u){a(u);a.Highcharts=u;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function u(a,h,p,q){a.hasOwnProperty(h)||(a[h]=q.apply(null,p))}a=a?a._modules:{};u(a,"Accessibility/A11yI18n.js",[a["Core/FormatUtilities.js"],a["Core/Utilities.js"]],function(a,h){var m=a.format,
q=h.pick,l;(function(a){function l(f,b){var c=f.indexOf("#each("),d=f.indexOf("#plural("),e=f.indexOf("["),r=f.indexOf("]");if(-1<c){r=f.slice(c).indexOf(")")+c;d=f.substring(0,c);e=f.substring(r+1);r=f.substring(c+6,r).split(",");c=Number(r[1]);f="";if(b=b[r[0]])for(c=isNaN(c)?b.length:c,c=0>c?b.length+c:Math.min(c,b.length),r=0;r<c;++r)f+=d+b[r]+e;return f.length?f:""}if(-1<d){e=f.slice(d).indexOf(")")+d;d=f.substring(d+8,e).split(",");switch(Number(b[d[0]])){case 0:f=q(d[4],d[1]);break;case 1:f=
q(d[2],d[1]);break;case 2:f=q(d[3],d[1]);break;default:f=d[1]}f?(b=f,b=b.trim&&b.trim()||b.replace(/^\s+|\s+$/g,"")):b="";return b}return-1<e?(d=f.substring(0,e),e=Number(f.substring(e+1,r)),f=void 0,b=b[d],!isNaN(e)&&b&&(0>e?(f=b[b.length+e],"undefined"===typeof f&&(f=b[0])):(f=b[e],"undefined"===typeof f&&(f=b[b.length-1]))),"undefined"!==typeof f?f:""):"{"+f+"}"}function w(f,b,c){var d=function(b,c){b=b.slice(c||0);var e=b.indexOf("{"),d=b.indexOf("}");if(-1<e&&d>e)return{statement:b.substring(e+
1,d),begin:c+e+1,end:c+d}},e=[],r=0;do{var a=d(f,r);var w=f.substring(r,a&&a.begin-1);w.length&&e.push({value:w,type:"constant"});a&&e.push({value:a.statement,type:"statement"});r=a?a.end+1:r+1}while(a);e.forEach(function(e){"statement"===e.type&&(e.value=l(e.value,b))});return m(e.reduce(function(b,e){return b+e.value},""),b,c)}function k(f,b){f=f.split(".");for(var c=this.options.lang,d=0;d<f.length;++d)c=c&&c[f[d]];return"string"===typeof c?w(c,b,this):""}var g=[];a.compose=function(f){-1===g.indexOf(f)&&
(g.push(f),f.prototype.langFormat=k);return f};a.i18nFormat=w})(l||(l={}));return l});u(a,"Accessibility/Utils/HTMLUtilities.js",[a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,h){function m(a){if("function"===typeof v.MouseEvent)return new v.MouseEvent(a.type,a);if(l.createEvent){var w=l.createEvent("MouseEvent");if(w.initMouseEvent)return w.initMouseEvent(a.type,a.bubbles,a.cancelable,a.view||v,a.detail,a.screenX,a.screenY,a.clientX,a.clientY,a.ctrlKey,a.altKey,a.shiftKey,a.metaKey,a.button,
a.relatedTarget),w}return q(a.type)}function q(a,k){k=k||{x:0,y:0};if("function"===typeof v.MouseEvent)return new v.MouseEvent(a,{bubbles:!0,cancelable:!0,composed:!0,view:v,detail:"click"===a?1:0,screenX:k.x,screenY:k.y,clientX:k.x,clientY:k.y});if(l.createEvent){var g=l.createEvent("MouseEvent");if(g.initMouseEvent)return g.initMouseEvent(a,!0,!0,v,"click"===a?1:0,k.x,k.y,k.x,k.y,!1,!1,!1,!1,0,null),g}return{type:a}}var l=a.doc,v=a.win,z=h.css;return{addClass:function(a,k){a.classList?a.classList.add(k):
0>a.className.indexOf(k)&&(a.className+=" "+k)},cloneMouseEvent:m,cloneTouchEvent:function(a){var k=function(a){for(var f=[],b=0;b<a.length;++b){var c=a.item(b);c&&f.push(c)}return f};if("function"===typeof v.TouchEvent)return k=new v.TouchEvent(a.type,{touches:k(a.touches),targetTouches:k(a.targetTouches),changedTouches:k(a.changedTouches),ctrlKey:a.ctrlKey,shiftKey:a.shiftKey,altKey:a.altKey,metaKey:a.metaKey,bubbles:a.bubbles,cancelable:a.cancelable,composed:a.composed,detail:a.detail,view:a.view}),
a.defaultPrevented&&k.preventDefault(),k;k=m(a);k.touches=a.touches;k.changedTouches=a.changedTouches;k.targetTouches=a.targetTouches;return k},escapeStringForHTML:function(a){return a.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#x27;").replace(/\//g,"&#x2F;")},getElement:function(a){return l.getElementById(a)},getFakeMouseEvent:q,getHeadingTagNameForElement:function(a){var k=function(f){f=parseInt(f.slice(1),10);return"h"+Math.min(6,f+1)},
g=function(f){var b;a:{for(b=f;b=b.previousSibling;){var c=b.tagName||"";if(/H[1-6]/.test(c)){b=c;break a}}b=""}if(b)return k(b);f=f.parentElement;if(!f)return"p";b=f.tagName;return/H[1-6]/.test(b)?k(b):g(f)};return g(a)},removeChildNodes:function(a){for(;a.lastChild;)a.removeChild(a.lastChild)},removeClass:function(a,k){a.classList?a.classList.remove(k):a.className=a.className.replace(new RegExp(k,"g"),"")},removeElement:function(a){a&&a.parentNode&&a.parentNode.removeChild(a)},reverseChildNodes:function(a){for(var k=
a.childNodes.length;k--;)a.appendChild(a.childNodes[k])},stripHTMLTagsFromString:function(a){return"string"===typeof a?a.replace(/<\/?[^>]+(>|$)/g,""):a},visuallyHideElement:function(a){z(a,{position:"absolute",width:"1px",height:"1px",overflow:"hidden",whiteSpace:"nowrap",clip:"rect(1px, 1px, 1px, 1px)",marginTop:"-3px","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=1)",filter:"alpha(opacity=1)",opacity:.01})}}});u(a,"Accessibility/Utils/ChartUtilities.js",[a["Core/Globals.js"],a["Accessibility/Utils/HTMLUtilities.js"],
a["Core/Utilities.js"]],function(a,h,p){function m(b,c){var e=c.type,a=b.hcEvents;g.createEvent&&(b.dispatchEvent||b.fireEvent)?b.dispatchEvent?b.dispatchEvent(c):b.fireEvent(e,c):a&&a[e]?d(b,e,c):b.element&&m(b.element,c)}function l(b){var c=b.chart,e={},d="Seconds";e.Seconds=((b.max||0)-(b.min||0))/1E3;e.Minutes=e.Seconds/60;e.Hours=e.Minutes/60;e.Days=e.Hours/24;["Minutes","Hours","Days"].forEach(function(b){2<e[b]&&(d=b)});var a=e[d].toFixed("Seconds"!==d&&"Minutes"!==d?1:0);return c.langFormat("accessibility.axis.timeRange"+
d,{chart:c,axis:b,range:a.replace(".0","")})}function v(b){var c=b.chart,e=c.options&&c.options.accessibility&&c.options.accessibility.screenReaderSection.axisRangeDateFormat||"",d=function(d){return b.dateTime?c.time.dateFormat(e,b[d]):b[d]};return c.langFormat("accessibility.axis.rangeFromTo",{chart:c,axis:b,rangeFrom:d("min"),rangeTo:d("max")})}function z(b){if(b.points&&b.points.length)return(b=c(b.points,function(b){return!!b.graphic}))&&b.graphic&&b.graphic.element}function w(b){var c=z(b);
return c&&c.parentNode||b.graph&&b.graph.element||b.group&&b.group.element}function k(b,c){c.setAttribute("aria-hidden",!1);c!==b.renderTo&&c.parentNode&&c.parentNode!==g.body&&(Array.prototype.forEach.call(c.parentNode.childNodes,function(b){b.hasAttribute("aria-hidden")||b.setAttribute("aria-hidden",!0)}),k(b,c.parentNode))}var g=a.doc,f=h.stripHTMLTagsFromString,b=p.defined,c=p.find,d=p.fireEvent;return{fireEventOnWrappedOrUnwrappedElement:m,getChartTitle:function(b){return f(b.options.title.text||
b.langFormat("accessibility.defaultChartTitle",{chart:b}))},getAxisDescription:function(b){return b&&(b.userOptions&&b.userOptions.accessibility&&b.userOptions.accessibility.description||b.axisTitle&&b.axisTitle.textStr||b.options.id||b.categories&&"categories"||b.dateTime&&"Time"||"values")},getAxisRangeDescription:function(b){var c=b.options||{};return c.accessibility&&"undefined"!==typeof c.accessibility.rangeDescription?c.accessibility.rangeDescription:b.categories?(c=b.chart,b=b.dataMax&&b.dataMin?
c.langFormat("accessibility.axis.rangeCategories",{chart:c,axis:b,numCategories:b.dataMax-b.dataMin+1}):"",b):!b.dateTime||0!==b.min&&0!==b.dataMin?v(b):l(b)},getPointFromXY:function(b,d,a){for(var e=b.length,f;e--;)if(f=c(b[e].points||[],function(b){return b.x===d&&b.y===a}))return f},getSeriesFirstPointElement:z,getSeriesFromName:function(b,c){return c?(b.series||[]).filter(function(b){return b.name===c}):b.series},getSeriesA11yElement:w,unhideChartElementFromAT:k,hideSeriesFromAT:function(b){(b=
w(b))&&b.setAttribute("aria-hidden",!0)},scrollToPoint:function(c){var a=c.series.xAxis,f=c.series.yAxis,e=a&&a.scrollbar?a:f;if((a=e&&e.scrollbar)&&b(a.to)&&b(a.from)){f=a.to-a.from;if(b(e.dataMin)&&b(e.dataMax)){var g=e.toPixels(e.dataMin),k=e.toPixels(e.dataMax);c=(e.toPixels(c["xAxis"===e.coll?"x":"y"]||0)-g)/(k-g)}else c=0;a.updatePosition(c-f/2,c+f/2);d(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:null})}}}});u(a,"Accessibility/Utils/DOMElementProvider.js",[a["Core/Globals.js"],
a["Accessibility/Utils/HTMLUtilities.js"]],function(a,h){var m=a.doc,q=h.removeElement;return function(){function a(){this.elements=[]}a.prototype.createElement=function(){var a=m.createElement.apply(m,arguments);this.elements.push(a);return a};a.prototype.destroyCreatedElements=function(){this.elements.forEach(function(a){q(a)});this.elements=[]};return a}()});u(a,"Accessibility/Utils/EventProvider.js",[a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,h){var m=h.addEvent;return function(){function h(){this.eventRemovers=
[]}h.prototype.addEvent=function(){var h=m.apply(a,arguments);this.eventRemovers.push(h);return h};h.prototype.removeAddedEvents=function(){this.eventRemovers.forEach(function(a){return a()});this.eventRemovers=[]};return h}()});u(a,"Accessibility/AccessibilityComponent.js",[a["Accessibility/Utils/ChartUtilities.js"],a["Accessibility/Utils/DOMElementProvider.js"],a["Accessibility/Utils/EventProvider.js"],a["Accessibility/Utils/HTMLUtilities.js"],a["Core/Utilities.js"]],function(a,h,p,q,l){var m=a.fireEventOnWrappedOrUnwrappedElement,
z=q.getFakeMouseEvent;a=l.extend;q=function(){function a(){this.proxyProvider=this.keyCodes=this.eventProvider=this.domElementProvider=this.chart=void 0}a.prototype.initBase=function(a,g){this.chart=a;this.eventProvider=new p;this.domElementProvider=new h;this.proxyProvider=g;this.keyCodes={left:37,right:39,up:38,down:40,enter:13,space:32,esc:27,tab:9,pageUp:33,pageDown:34,end:35,home:36}};a.prototype.addEvent=function(a,g,f,b){return this.eventProvider.addEvent(a,g,f,b)};a.prototype.createElement=
function(a,g){return this.domElementProvider.createElement(a,g)};a.prototype.fakeClickEvent=function(a){var g=z("click");m(a,g)};a.prototype.destroyBase=function(){this.domElementProvider.destroyCreatedElements();this.eventProvider.removeAddedEvents()};return a}();a(q.prototype,{init:function(){},getKeyboardNavigation:function(){},onChartUpdate:function(){},onChartRender:function(){},destroy:function(){}});return q});u(a,"Accessibility/KeyboardNavigationHandler.js",[a["Core/Utilities.js"]],function(a){var h=
a.find;a=function(){function a(a,h){this.chart=a;this.keyCodeMap=h.keyCodeMap||[];this.validate=h.validate;this.init=h.init;this.terminate=h.terminate;this.response={success:1,prev:2,next:3,noHandler:4,fail:5}}a.prototype.run=function(a){var l=a.which||a.keyCode,m=this.response.noHandler,p=h(this.keyCodeMap,function(a){return-1<a[0].indexOf(l)});p?m=p[1].call(this,l,a):9===l&&(m=this.response[a.shiftKey?"prev":"next"]);return m};return a}();"";return a});u(a,"Accessibility/Components/ContainerComponent.js",
[a["Accessibility/AccessibilityComponent.js"],a["Accessibility/KeyboardNavigationHandler.js"],a["Accessibility/Utils/ChartUtilities.js"],a["Core/Globals.js"],a["Accessibility/Utils/HTMLUtilities.js"]],function(a,h,p,q,l){var m=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,c){b.__proto__=c}||function(b,c){for(var a in c)c.hasOwnProperty(a)&&(b[a]=c[a])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,
c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),z=p.unhideChartElementFromAT,w=p.getChartTitle,k=q.doc,g=l.stripHTMLTagsFromString;return function(a){function b(){return null!==a&&a.apply(this,arguments)||this}m(b,a);b.prototype.onChartUpdate=function(){this.handleSVGTitleElement();this.setSVGContainerLabel();this.setGraphicContainerAttrs();this.setRenderToAttrs();this.makeCreditsAccessible()};b.prototype.handleSVGTitleElement=function(){var b=this.chart,a="highcharts-title-"+
b.index,e=g(b.langFormat("accessibility.svgContainerTitle",{chartTitle:w(b)}));if(e.length){var f=this.svgTitleElement=this.svgTitleElement||k.createElementNS("http://www.w3.org/2000/svg","title");f.textContent=e;f.id=a;b.renderTo.insertBefore(f,b.renderTo.firstChild)}};b.prototype.setSVGContainerLabel=function(){var b=this.chart,a=b.langFormat("accessibility.svgContainerLabel",{chartTitle:w(b)});b.renderer.box&&a.length&&b.renderer.box.setAttribute("aria-label",a)};b.prototype.setGraphicContainerAttrs=
function(){var b=this.chart,a=b.langFormat("accessibility.graphicContainerLabel",{chartTitle:w(b)});a.length&&b.container.setAttribute("aria-label",a)};b.prototype.setRenderToAttrs=function(){var b=this.chart;"disabled"!==b.options.accessibility.landmarkVerbosity?b.renderTo.setAttribute("role","region"):b.renderTo.removeAttribute("role");b.renderTo.setAttribute("aria-label",b.langFormat("accessibility.chartContainerLabel",{title:w(b),chart:b}))};b.prototype.makeCreditsAccessible=function(){var b=
this.chart,a=b.credits;a&&(a.textStr&&a.element.setAttribute("aria-label",b.langFormat("accessibility.credits",{creditsStr:g(a.textStr)})),z(b,a.element))};b.prototype.getKeyboardNavigation=function(){var b=this.chart;return new h(b,{keyCodeMap:[],validate:function(){return!0},init:function(){var a=b.accessibility;a&&a.keyboardNavigation.tabindexContainer.focus()}})};b.prototype.destroy=function(){this.chart.renderTo.setAttribute("aria-hidden",!0)};return b}(a)});u(a,"Accessibility/FocusBorder.js",
[a["Core/Renderer/SVG/SVGLabel.js"],a["Core/Utilities.js"]],function(a,h){var m=h.addEvent,q=h.pick,l;(function(h){function l(){var b=this.focusElement,a=this.options.accessibility.keyboardNavigation.focusBorder;b&&(b.removeFocusBorder(),a.enabled&&b.addFocusBorder(a.margin,{stroke:a.style.color,strokeWidth:a.style.lineWidth,r:a.style.borderRadius}))}function w(b,a){var c=this.options.accessibility.keyboardNavigation.focusBorder;(a=a||b.element)&&a.focus&&(a.hcEvents&&a.hcEvents.focusin||m(a,"focusin",
function(){}),a.focus(),c.hideBrowserFocusOutline&&(a.style.outline="none"));this.focusElement&&this.focusElement.removeFocusBorder();this.focusElement=b;this.renderFocusBorder()}function k(b){if(!b.focusBorderDestroyHook){var a=b.destroy;b.destroy=function(){b.focusBorder&&b.focusBorder.destroy&&b.focusBorder.destroy();return a.apply(b,arguments)};b.focusBorderDestroyHook=a}}function g(b,c){this.focusBorder&&this.removeFocusBorder();var d=this.getBBox(),e=q(b,3);d.x+=this.translateX?this.translateX:
0;d.y+=this.translateY?this.translateY:0;var r=d.x-e,x=d.y-e,g=d.width+2*e,C=d.height+2*e,h=this instanceof a;if("text"===this.element.nodeName||h){var l=!!this.rotation;if(h)var D={x:l?1:0,y:0};else{var F=D=0;"middle"===this.attr("text-anchor")?D=F=.5:this.rotation?D=.25:F=.75;D={x:D,y:F}}F=+this.attr("x");var n=+this.attr("y");isNaN(F)||(r=F-d.width*D.x-e);isNaN(n)||(x=n-d.height*D.y-e);h&&l&&(h=g,g=C,C=h,isNaN(F)||(r=F-d.height*D.x-e),isNaN(n)||(x=n-d.width*D.y-e))}this.focusBorder=this.renderer.rect(r,
x,g,C,parseInt((c&&c.r||0).toString(),10)).addClass("highcharts-focus-border").attr({zIndex:99}).add(this.parentGroup);this.renderer.styledMode||this.focusBorder.attr({stroke:c&&c.stroke,"stroke-width":c&&c.strokeWidth});f(this,b,c);k(this)}function f(b){for(var a=[],c=1;c<arguments.length;c++)a[c-1]=arguments[c];b.focusBorderUpdateHooks||(b.focusBorderUpdateHooks={},e.forEach(function(c){c+="Setter";var d=b[c]||b._defaultSetter;b.focusBorderUpdateHooks[c]=d;b[c]=function(){var c=d.apply(b,arguments);
b.addFocusBorder.apply(b,a);return c}}))}function b(){c(this);this.focusBorderDestroyHook&&(this.destroy=this.focusBorderDestroyHook,delete this.focusBorderDestroyHook);this.focusBorder&&(this.focusBorder.destroy(),delete this.focusBorder)}function c(b){b.focusBorderUpdateHooks&&(Object.keys(b.focusBorderUpdateHooks).forEach(function(a){var c=b.focusBorderUpdateHooks[a];c===b._defaultSetter?delete b[a]:b[a]=c}),delete b.focusBorderUpdateHooks)}var d=[],e="x y transform width height r d stroke-width".split(" ");
h.compose=function(a,c){-1===d.indexOf(a)&&(d.push(a),a=a.prototype,a.renderFocusBorder=l,a.setFocusToElement=w);-1===d.indexOf(c)&&(d.push(c),c=c.prototype,c.addFocusBorder=g,c.removeFocusBorder=b)}})(l||(l={}));return l});u(a,"Accessibility/Utils/Announcer.js",[a["Core/Renderer/HTML/AST.js"],a["Accessibility/Utils/DOMElementProvider.js"],a["Core/Globals.js"],a["Accessibility/Utils/HTMLUtilities.js"],a["Core/Utilities.js"]],function(a,h,p,q,l){var m=p.doc,z=q.addClass,w=q.visuallyHideElement,k=l.attr;
return function(){function g(a,b){this.chart=a;this.domElementProvider=new h;this.announceRegion=this.addAnnounceRegion(b)}g.prototype.destroy=function(){this.domElementProvider.destroyCreatedElements()};g.prototype.announce=function(f){var b=this;a.setElementHTML(this.announceRegion,f);this.clearAnnouncementRegionTimer&&clearTimeout(this.clearAnnouncementRegionTimer);this.clearAnnouncementRegionTimer=setTimeout(function(){b.announceRegion.innerHTML="";delete b.clearAnnouncementRegionTimer},1E3)};
g.prototype.addAnnounceRegion=function(a){var b=this.chart.announcerContainer||this.createAnnouncerContainer(),c=this.domElementProvider.createElement("div");k(c,{"aria-hidden":!1,"aria-live":a});this.chart.styledMode?z(c,"highcharts-visually-hidden"):w(c);b.appendChild(c);return c};g.prototype.createAnnouncerContainer=function(){var a=this.chart,b=m.createElement("div");k(b,{"aria-hidden":!1,"class":"highcharts-announcer-container"});b.style.position="relative";a.renderTo.insertBefore(b,a.renderTo.firstChild);
return a.announcerContainer=b};return g}()});u(a,"Accessibility/Components/AnnotationsA11y.js",[a["Accessibility/Utils/HTMLUtilities.js"]],function(a){function h(a){return(a.annotations||[]).reduce(function(a,g){g.options&&!1!==g.options.visible&&(a=a.concat(g.labels));return a},[])}function m(a){return a.options&&a.options.accessibility&&a.options.accessibility.description||a.graphic&&a.graphic.text&&a.graphic.text.textStr||""}function q(a){var k=a.options&&a.options.accessibility&&a.options.accessibility.description;
if(k)return k;k=a.chart;var g=m(a),f=a.points.filter(function(b){return!!b.graphic}).map(function(b){var a=b.accessibility&&b.accessibility.valueDescription||b.graphic&&b.graphic.element&&b.graphic.element.getAttribute("aria-label")||"";b=b&&b.series.name||"";return(b?b+", ":"")+"data point "+a}).filter(function(b){return!!b}),b=f.length,c="accessibility.screenReaderSection.annotations.description"+(1<b?"MultiplePoints":b?"SinglePoint":"NoPoints");a={annotationText:g,annotation:a,numPoints:b,annotationPoint:f[0],
additionalAnnotationPoints:f.slice(1)};return k.langFormat(c,a)}function l(a){return h(a).map(function(a){return(a=v(z(q(a))))?"<li>"+a+"</li>":""})}var v=a.escapeStringForHTML,z=a.stripHTMLTagsFromString;return{getAnnotationsInfoHTML:function(a){var k=a.annotations;return k&&k.length?'<ul style="list-style-type: none">'+l(a).join(" ")+"</ul>":""},getAnnotationLabelDescription:q,getAnnotationListItems:l,getPointAnnotationTexts:function(a){var k=h(a.series.chart).filter(function(g){return-1<g.points.indexOf(a)});
return k.length?k.map(function(a){return""+m(a)}):[]}}});u(a,"Accessibility/Components/InfoRegionsComponent.js",[a["Core/Renderer/HTML/AST.js"],a["Core/Chart/Chart.js"],a["Core/FormatUtilities.js"],a["Core/Globals.js"],a["Core/Utilities.js"],a["Accessibility/A11yI18n.js"],a["Accessibility/AccessibilityComponent.js"],a["Accessibility/Utils/Announcer.js"],a["Accessibility/Components/AnnotationsA11y.js"],a["Accessibility/Utils/ChartUtilities.js"],a["Accessibility/Utils/HTMLUtilities.js"]],function(a,
h,p,q,l,v,z,w,k,g,f){var b=p.format,c=q.doc,d=l.attr;p=l.extend;var e=l.pick,r=k.getAnnotationsInfoHTML,C=g.getAxisDescription,m=g.getAxisRangeDescription,B=g.getChartTitle,H=g.unhideChartElementFromAT,x=f.addClass,A=f.getElement,I=f.getHeadingTagNameForElement,G=f.stripHTMLTagsFromString,E=f.visuallyHideElement;h.prototype.getTypeDescription=function(b){var a=b[0],c=this.series&&this.series[0]||{};c={numSeries:this.series.length,numPoints:c.points&&c.points.length,chart:this,mapTitle:c.mapTitle};
if(!a)return this.langFormat("accessibility.chartTypes.emptyChart",c);if("map"===a)return c.mapTitle?this.langFormat("accessibility.chartTypes.mapTypeDescription",c):this.langFormat("accessibility.chartTypes.unknownMap",c);if(1<this.types.length)return this.langFormat("accessibility.chartTypes.combinationChart",c);b=b[0];a=this.langFormat("accessibility.seriesTypeDescriptions."+b,c);var d=this.series&&2>this.series.length?"Single":"Multiple";return(this.langFormat("accessibility.chartTypes."+b+d,
c)||this.langFormat("accessibility.chartTypes.default"+d,c))+(a?" "+a:"")};h=function(){};h.prototype=new z;p(h.prototype,{init:function(){var b=this.chart,a=this;this.initRegionsDefinitions();this.addEvent(b,"aftergetTableAST",function(b){a.onDataTableCreated(b)});this.addEvent(b,"afterViewData",function(b){a.dataTableDiv=b;setTimeout(function(){a.focusDataTable()},300)});this.announcer=new w(b,"assertive")},initRegionsDefinitions:function(){var b=this;this.screenReaderSections={before:{element:null,
buildContent:function(a){var c=a.options.accessibility.screenReaderSection.beforeChartFormatter;return c?c(a):b.defaultBeforeChartFormatter(a)},insertIntoDOM:function(b,a){a.renderTo.insertBefore(b,a.renderTo.firstChild)},afterInserted:function(){"undefined"!==typeof b.sonifyButtonId&&b.initSonifyButton(b.sonifyButtonId);"undefined"!==typeof b.dataTableButtonId&&b.initDataTableButton(b.dataTableButtonId)}},after:{element:null,buildContent:function(a){var c=a.options.accessibility.screenReaderSection.afterChartFormatter;
return c?c(a):b.defaultAfterChartFormatter()},insertIntoDOM:function(b,a){a.renderTo.insertBefore(b,a.container.nextSibling)},afterInserted:function(){b.chart.accessibility&&b.chart.accessibility.keyboardNavigation.updateExitAnchor()}}}},onChartRender:function(){var b=this;this.linkedDescriptionElement=this.getLinkedDescriptionElement();this.setLinkedDescriptionAttrs();Object.keys(this.screenReaderSections).forEach(function(a){b.updateScreenReaderSection(a)})},getLinkedDescriptionElement:function(){var a=
this.chart.options.accessibility.linkedDescription;if(a){if("string"!==typeof a)return a;a=b(a,this.chart);a=c.querySelectorAll(a);if(1===a.length)return a[0]}},setLinkedDescriptionAttrs:function(){var b=this.linkedDescriptionElement;b&&(b.setAttribute("aria-hidden","true"),x(b,"highcharts-linked-description"))},updateScreenReaderSection:function(b){var c=this.chart,d=this.screenReaderSections[b],e=d.buildContent(c),y=d.element=d.element||this.createElement("div"),f=y.firstChild||this.createElement("div");
e?(this.setScreenReaderSectionAttribs(y,b),a.setElementHTML(f,e),y.appendChild(f),d.insertIntoDOM(y,c),c.styledMode?x(f,"highcharts-visually-hidden"):E(f),H(c,f),d.afterInserted&&d.afterInserted()):(y.parentNode&&y.parentNode.removeChild(y),delete d.element)},setScreenReaderSectionAttribs:function(b,a){var c=this.chart,e=c.langFormat("accessibility.screenReaderSection."+a+"RegionLabel",{chart:c,chartTitle:B(c)});d(b,{id:"highcharts-screen-reader-region-"+a+"-"+c.index,"aria-label":e});b.style.position=
"relative";"all"===c.options.accessibility.landmarkVerbosity&&e&&b.setAttribute("role","region")},defaultBeforeChartFormatter:function(){var b=this.chart,a=b.options.accessibility.screenReaderSection.beforeChartFormat;if(!a)return"";var c=this.getAxesDescription(),d=b.sonify&&b.options.sonification&&b.options.sonification.enabled,e="highcharts-a11y-sonify-data-btn-"+b.index,f="hc-linkto-highcharts-data-table-"+b.index,M=r(b),K=b.langFormat("accessibility.screenReaderSection.annotations.heading",{chart:b});
c={headingTagName:I(b.renderTo),chartTitle:B(b),typeDescription:this.getTypeDescriptionText(),chartSubtitle:this.getSubtitleText(),chartLongdesc:this.getLongdescText(),xAxisDescription:c.xAxis,yAxisDescription:c.yAxis,playAsSoundButton:d?this.getSonifyButtonText(e):"",viewTableButton:b.getCSV?this.getDataTableButtonText(f):"",annotationsTitle:M?K:"",annotationsList:M};b=v.i18nFormat(a,c,b);this.dataTableButtonId=f;this.sonifyButtonId=e;return b.replace(/<(\w+)[^>]*?>\s*<\/\1>/g,"")},defaultAfterChartFormatter:function(){var b=
this.chart,a=b.options.accessibility.screenReaderSection.afterChartFormat;if(!a)return"";var c={endOfChartMarker:this.getEndOfChartMarkerText()};return v.i18nFormat(a,c,b).replace(/<(\w+)[^>]*?>\s*<\/\1>/g,"")},getLinkedDescription:function(){var b=this.linkedDescriptionElement;return G(b&&b.innerHTML||"")},getLongdescText:function(){var b=this.chart.options,a=b.caption;a=a&&a.text;var c=this.getLinkedDescription();return b.accessibility.description||c||a||""},getTypeDescriptionText:function(){var b=
this.chart;return b.types?b.options.accessibility.typeDescription||b.getTypeDescription(b.types):""},getDataTableButtonText:function(b){var a=this.chart;a=a.langFormat("accessibility.table.viewAsDataTableButtonText",{chart:a,chartTitle:B(a)});return'<button id="'+b+'">'+a+"</button>"},getSonifyButtonText:function(b){var a=this.chart;if(a.options.sonification&&!1===a.options.sonification.enabled)return"";a=a.langFormat("accessibility.sonification.playAsSoundButtonText",{chart:a,chartTitle:B(a)});return'<button id="'+
b+'">'+a+"</button>"},getSubtitleText:function(){var b=this.chart.options.subtitle;return G(b&&b.text||"")},getEndOfChartMarkerText:function(){var b=this.chart,a=b.langFormat("accessibility.screenReaderSection.endOfChartMarker",{chart:b});return'<div id="highcharts-end-of-chart-marker-'+b.index+'">'+a+"</div>"},onDataTableCreated:function(b){var a=this.chart;if(a.options.accessibility.enabled){this.viewDataTableButton&&this.viewDataTableButton.setAttribute("aria-expanded","true");var c=b.tree.attributes||
{};c.tabindex=-1;c.summary=a.langFormat("accessibility.table.tableSummary",{chart:a});b.tree.attributes=c}},focusDataTable:function(){var b=this.dataTableDiv;(b=b&&b.getElementsByTagName("table")[0])&&b.focus&&b.focus()},initSonifyButton:function(b){var a=this,c=this.sonifyButton=A(b),d=this.chart,e=function(b){c&&(c.setAttribute("aria-hidden","true"),c.setAttribute("aria-label",""));b.preventDefault();b.stopPropagation();b=d.langFormat("accessibility.sonification.playAsSoundClickAnnouncement",{chart:d});
a.announcer.announce(b);setTimeout(function(){c&&(c.removeAttribute("aria-hidden"),c.removeAttribute("aria-label"));d.sonify&&d.sonify()},1E3)};c&&d&&(c.setAttribute("tabindex",-1),c.onclick=function(b){(d.options.accessibility&&d.options.accessibility.screenReaderSection.onPlayAsSoundClick||e).call(this,b,d)})},initDataTableButton:function(b){var a=this.viewDataTableButton=A(b),c=this.chart;b=b.replace("hc-linkto-","");a&&(d(a,{tabindex:-1,"aria-expanded":!!A(b)}),a.onclick=c.options.accessibility.screenReaderSection.onViewDataTableClick||
function(){c.viewData()})},getAxesDescription:function(){var b=this.chart,a=function(a,c){a=b[a];return 1<a.length||a[0]&&e(a[0].options.accessibility&&a[0].options.accessibility.enabled,c)},c=!!b.types&&0>b.types.indexOf("map"),d=!!b.hasCartesianSeries,y=a("xAxis",!b.angular&&d&&c);a=a("yAxis",d&&c);c={};y&&(c.xAxis=this.getAxisDescriptionText("xAxis"));a&&(c.yAxis=this.getAxisDescriptionText("yAxis"));return c},getAxisDescriptionText:function(b){var a=this.chart,c=a[b];return a.langFormat("accessibility.axis."+
b+"Description"+(1<c.length?"Plural":"Singular"),{chart:a,names:c.map(function(b){return C(b)}),ranges:c.map(function(b){return m(b)}),numAxes:c.length})},destroy:function(){this.announcer&&this.announcer.destroy()}});return h});u(a,"Accessibility/KeyboardNavigation.js",[a["Core/Chart/Chart.js"],a["Core/Globals.js"],a["Core/Utilities.js"],a["Accessibility/Utils/EventProvider.js"],a["Accessibility/Utils/HTMLUtilities.js"]],function(a,h,p,q,l){var m=h.doc,z=h.win,w=p.addEvent,k=p.fireEvent,g=l.getElement;
a=function(){function a(b,a){this.components=this.chart=void 0;this.currentModuleIx=NaN;this.exitAnchor=this.eventProvider=void 0;this.modules=[];this.tabindexContainer=void 0;this.init(b,a)}a.prototype.init=function(b,a){var c=this,e=this.eventProvider=new q;this.chart=b;this.components=a;this.modules=[];this.currentModuleIx=0;this.update();e.addEvent(this.tabindexContainer,"keydown",function(b){return c.onKeydown(b)});e.addEvent(this.tabindexContainer,"focus",function(b){return c.onFocus(b)});["mouseup",
"touchend"].forEach(function(b){return e.addEvent(m,b,function(){return c.onMouseUp()})});["mousedown","touchstart"].forEach(function(a){return e.addEvent(b.renderTo,a,function(){c.isClickingChart=!0})});e.addEvent(b.renderTo,"mouseover",function(){c.pointerIsOverChart=!0});e.addEvent(b.renderTo,"mouseout",function(){c.pointerIsOverChart=!1})};a.prototype.update=function(b){var a=this.chart.options.accessibility;a=a&&a.keyboardNavigation;var d=this.components;this.updateContainerTabindex();a&&a.enabled&&
b&&b.length?(this.modules=b.reduce(function(b,a){a=d[a].getKeyboardNavigation();return b.concat(a)},[]),this.updateExitAnchor()):(this.modules=[],this.currentModuleIx=0,this.removeExitAnchor())};a.prototype.onFocus=function(b){var a=this.chart;b=b.relatedTarget&&a.container.contains(b.relatedTarget);this.exiting||this.tabbingInBackwards||this.isClickingChart||b||!this.modules[0]||this.modules[0].init(1);this.exiting=!1};a.prototype.onMouseUp=function(){delete this.isClickingChart;if(!this.keyboardReset&&
!this.pointerIsOverChart){var b=this.chart,a=this.modules&&this.modules[this.currentModuleIx||0];a&&a.terminate&&a.terminate();b.focusElement&&b.focusElement.removeFocusBorder();this.currentModuleIx=0;this.keyboardReset=!0}};a.prototype.onKeydown=function(b){b=b||z.event;var a=this.modules&&this.modules.length&&this.modules[this.currentModuleIx],d;this.exiting=this.keyboardReset=!1;if(a){var e=a.run(b);e===a.response.success?d=!0:e===a.response.prev?d=this.prev():e===a.response.next&&(d=this.next());
d&&(b.preventDefault(),b.stopPropagation())}};a.prototype.prev=function(){return this.move(-1)};a.prototype.next=function(){return this.move(1)};a.prototype.move=function(b){var a=this.modules&&this.modules[this.currentModuleIx];a&&a.terminate&&a.terminate(b);this.chart.focusElement&&this.chart.focusElement.removeFocusBorder();this.currentModuleIx+=b;if(a=this.modules&&this.modules[this.currentModuleIx]){if(a.validate&&!a.validate())return this.move(b);if(a.init)return a.init(b),!0}this.currentModuleIx=
0;this.exiting=!0;0<b?this.exitAnchor.focus():this.tabindexContainer.focus();return!1};a.prototype.updateExitAnchor=function(){var b=g("highcharts-end-of-chart-marker-"+this.chart.index);this.removeExitAnchor();b?(this.makeElementAnExitAnchor(b),this.exitAnchor=b):this.createExitAnchor()};a.prototype.updateContainerTabindex=function(){var b=this.chart.options.accessibility;b=b&&b.keyboardNavigation;b=!(b&&!1===b.enabled);var a=this.chart,d=a.container;a.renderTo.hasAttribute("tabindex")&&(d.removeAttribute("tabindex"),
d=a.renderTo);this.tabindexContainer=d;var e=d.getAttribute("tabindex");b&&!e?d.setAttribute("tabindex","0"):b||a.container.removeAttribute("tabindex")};a.prototype.makeElementAnExitAnchor=function(b){var a=this.tabindexContainer.getAttribute("tabindex")||0;b.setAttribute("class","highcharts-exit-anchor");b.setAttribute("tabindex",a);b.setAttribute("aria-hidden",!1);this.addExitAnchorEventsToEl(b)};a.prototype.createExitAnchor=function(){var b=this.chart,a=this.exitAnchor=m.createElement("div");b.renderTo.appendChild(a);
this.makeElementAnExitAnchor(a)};a.prototype.removeExitAnchor=function(){this.exitAnchor&&this.exitAnchor.parentNode&&(this.exitAnchor.parentNode.removeChild(this.exitAnchor),delete this.exitAnchor)};a.prototype.addExitAnchorEventsToEl=function(b){var a=this.chart,d=this;this.eventProvider.addEvent(b,"focus",function(b){b=b||z.event;b.relatedTarget&&a.container.contains(b.relatedTarget)||d.exiting?d.exiting=!1:(d.tabbingInBackwards=!0,d.tabindexContainer.focus(),delete d.tabbingInBackwards,b.preventDefault(),
d.modules&&d.modules.length&&(d.currentModuleIx=d.modules.length-1,(b=d.modules[d.currentModuleIx])&&b.validate&&!b.validate()?d.prev():b&&b.init(-1)))})};a.prototype.destroy=function(){this.removeExitAnchor();this.eventProvider.removeAddedEvents();this.chart.container.removeAttribute("tabindex")};return a}();(function(a){function b(){var b=this;k(this,"dismissPopupContent",{},function(){b.tooltip&&b.tooltip.hide(0);b.hideExportMenu()})}function c(b){27===(b.which||b.keyCode)&&h.charts&&h.charts.forEach(function(b){b&&
b.dismissPopupContent&&b.dismissPopupContent()})}var d=[];a.compose=function(a){-1===d.indexOf(a)&&(d.push(a),a.prototype.dismissPopupContent=b);-1===d.indexOf(m)&&(d.push(m),w(m,"keydown",c));return a}})(a||(a={}));return a});u(a,"Accessibility/Components/LegendComponent.js",[a["Core/Animation/AnimationUtilities.js"],a["Core/Chart/Chart.js"],a["Core/Globals.js"],a["Core/Legend/Legend.js"],a["Core/Utilities.js"],a["Accessibility/AccessibilityComponent.js"],a["Accessibility/KeyboardNavigationHandler.js"],
a["Accessibility/Utils/HTMLUtilities.js"],a["Accessibility/Utils/ChartUtilities.js"]],function(a,h,p,q,l,v,z,w,k){function g(b){var a=b.legend&&b.legend.allItems,c=b.options.legend.accessibility||{};return!(!a||!a.length||b.colorAxis&&b.colorAxis.length||!1===c.enabled)}var f=a.animObject,b=l.addEvent;a=l.extend;var c=l.fireEvent,d=l.isNumber,e=l.pick,r=l.syncTimeout,C=w.stripHTMLTagsFromString,m=w.addClass,B=w.removeClass,H=k.getChartTitle;h.prototype.highlightLegendItem=function(b){var a=this.legend.allItems,
e=this.accessibility&&this.accessibility.components.legend.highlightedLegendItemIx,f=a[b];return f?(d(e)&&a[e]&&c(a[e].legendGroup.element,"mouseout"),a=this.legend,b=a.allItems[b].pageIx,e=a.currentPage,"undefined"!==typeof b&&b+1!==e&&a.scroll(1+b-e),b=f.legendItem,a=f.a11yProxyElement&&f.a11yProxyElement.buttonElement,b&&b.element&&a&&this.setFocusToElement(b,a),f.legendGroup&&c(f.legendGroup.element,"mouseover"),!0):!1};b(q,"afterColorizeItem",function(b){var a=b.item;this.chart.options.accessibility.enabled&&
a&&a.a11yProxyElement&&a.a11yProxyElement.buttonElement.setAttribute("aria-pressed",b.visible?"true":"false")});h=function(){};h.prototype=new v;a(h.prototype,{init:function(){var b=this;this.recreateProxies();this.addEvent(q,"afterScroll",function(){this.chart===b.chart&&(b.proxyProvider.updateGroupProxyElementPositions("legend"),b.updateLegendItemProxyVisibility(),-1<b.highlightedLegendItemIx&&this.chart.highlightLegendItem(b.highlightedLegendItemIx))});this.addEvent(q,"afterPositionItem",function(a){this.chart===
b.chart&&this.chart.renderer&&b.updateProxyPositionForItem(a.item)});this.addEvent(q,"afterRender",function(){this.chart===b.chart&&this.chart.renderer&&b.recreateProxies()&&r(function(){return b.proxyProvider.updateGroupProxyElementPositions("legend")},f(e(this.chart.renderer.globalAnimation,!0)).duration)})},updateLegendItemProxyVisibility:function(){var b=this.chart,a=b.legend,c=a.currentPage||1,d=a.clipHeight||0;(a.allItems||[]).forEach(function(e){if(e.a11yProxyElement){var f=e.a11yProxyElement.element,
r=!1;if(a.pages&&a.pages.length){r=e.pageIx||0;var g=e._legendItemPos?e._legendItemPos[1]:0;e=e.legendItem?Math.round(e.legendItem.getBBox().height):0;r=g+e-a.pages[r]>d||r!==c-1}r?b.styledMode?m(f,"highcharts-a11y-invisible"):f.style.visibility="hidden":(B(f,"highcharts-a11y-invisible"),f.style.visibility="")}})},onChartRender:function(){g(this.chart)||this.removeProxies()},highlightAdjacentLegendPage:function(b){var a=this.chart,c=a.legend;b=(c.currentPage||1)+b;var d=c.pages||[];if(0<b&&b<=d.length){d=
c.allItems.length;for(var e=0;e<d;++e)if(c.allItems[e].pageIx+1===b){a.highlightLegendItem(e)&&(this.highlightedLegendItemIx=e);break}}},updateProxyPositionForItem:function(b){b.a11yProxyElement&&b.a11yProxyElement.refreshPosition()},recreateProxies:function(){this.removeProxies();return g(this.chart)?(this.addLegendProxyGroup(),this.proxyLegendItems(),this.updateLegendItemProxyVisibility(),this.updateLegendTitle(),!0):!1},removeProxies:function(){this.proxyProvider.removeGroup("legend")},updateLegendTitle:function(){var b=
this.chart,a=C((b.legend&&b.legend.options.title&&b.legend.options.title.text||"").replace(/<br ?\/?>/g," "));b=b.langFormat("accessibility.legend.legendLabel"+(a?"":"NoTitle"),{chart:b,legendTitle:a,chartTitle:H(b)});this.proxyProvider.updateGroupAttrs("legend",{"aria-label":b})},addLegendProxyGroup:function(){this.proxyProvider.addGroup("legend","ul",{"aria-label":"_placeholder_",role:"all"===this.chart.options.accessibility.landmarkVerbosity?"region":null})},proxyLegendItems:function(){var b=this;
(this.chart.legend&&this.chart.legend.allItems||[]).forEach(function(a){a.legendItem&&a.legendItem.element&&b.proxyLegendItem(a)})},proxyLegendItem:function(b){if(b.legendItem&&b.legendGroup){var a=this.chart.langFormat("accessibility.legend.legendItem",{chart:this.chart,itemName:C(b.name),item:b});b.a11yProxyElement=this.proxyProvider.addProxyElement("legend",{click:b.legendItem,visual:(b.legendGroup.div?b.legendItem:b.legendGroup).element},{tabindex:-1,"aria-pressed":b.visible,"aria-label":a})}},
getKeyboardNavigation:function(){var b=this.keyCodes,a=this,c=this.chart;return new z(c,{keyCodeMap:[[[b.left,b.right,b.up,b.down],function(b){return a.onKbdArrowKey(this,b)}],[[b.enter,b.space],function(c){return p.isFirefox&&c===b.space?this.response.success:a.onKbdClick(this)}],[[b.pageDown,b.pageUp],function(c){a.highlightAdjacentLegendPage(c===b.pageDown?1:-1);return this.response.success}]],validate:function(){return a.shouldHaveLegendNavigation()},init:function(b){return a.onKbdNavigationInit(b)},
terminate:function(){a.highlightedLegendItemIx=-1;c.legend.allItems.forEach(function(b){return b.setState("",!0)})}})},onKbdArrowKey:function(b,a){var c=this.keyCodes,d=b.response,e=this.chart,f=e.options.accessibility,r=e.legend.allItems.length;a=a===c.left||a===c.up?-1:1;return e.highlightLegendItem(this.highlightedLegendItemIx+a)?(this.highlightedLegendItemIx+=a,d.success):1<r&&f.keyboardNavigation.wrapAround?(b.init(a),d.success):d[0<a?"next":"prev"]},onKbdClick:function(b){var a=this.chart.legend.allItems[this.highlightedLegendItemIx];
a&&a.a11yProxyElement&&a.a11yProxyElement.click();return b.response.success},shouldHaveLegendNavigation:function(){var b=this.chart,a=b.colorAxis&&b.colorAxis.length,c=(b.options.legend||{}).accessibility||{};return!!(b.legend&&b.legend.allItems&&b.legend.display&&!a&&c.enabled&&c.keyboardNavigation&&c.keyboardNavigation.enabled)},onKbdNavigationInit:function(b){var a=this.chart,c=a.legend.allItems.length-1;b=0<b?0:c;a.highlightLegendItem(b);this.highlightedLegendItemIx=b}});return h});u(a,"Accessibility/Components/MenuComponent.js",
[a["Core/Chart/Chart.js"],a["Core/Utilities.js"],a["Accessibility/AccessibilityComponent.js"],a["Accessibility/KeyboardNavigationHandler.js"],a["Accessibility/Utils/ChartUtilities.js"],a["Accessibility/Utils/HTMLUtilities.js"]],function(a,h,p,q,l,v){var m=h.attr;h=h.extend;var w=l.getChartTitle,k=l.unhideChartElementFromAT,g=v.getFakeMouseEvent;a.prototype.showExportMenu=function(){var a=this.exportSVGElements&&this.exportSVGElements[0];if(a&&(a=a.element,a.onclick))a.onclick(g("click"))};a.prototype.hideExportMenu=
function(){var a=this.exportDivElements;a&&this.exportContextMenu&&(a.forEach(function(b){if(b&&"highcharts-menu-item"===b.className&&b.onmouseout)b.onmouseout(g("mouseout"))}),this.highlightedExportItemIx=0,this.exportContextMenu.hideMenu(),this.container.focus())};a.prototype.highlightExportItem=function(a){var b=this.exportDivElements&&this.exportDivElements[a],c=this.exportDivElements&&this.exportDivElements[this.highlightedExportItemIx];if(b&&"LI"===b.tagName&&(!b.children||!b.children.length)){var d=
!!(this.renderTo.getElementsByTagName("g")[0]||{}).focus;b.focus&&d&&b.focus();if(c&&c.onmouseout)c.onmouseout(g("mouseout"));if(b.onmouseover)b.onmouseover(g("mouseover"));this.highlightedExportItemIx=a;return!0}return!1};a.prototype.highlightLastExportItem=function(){if(this.exportDivElements)for(var a=this.exportDivElements.length;a--;)if(this.highlightExportItem(a))return!0;return!1};a=function(){};a.prototype=new p;h(a.prototype,{init:function(){var a=this.chart,b=this;this.addEvent(a,"exportMenuShown",
function(){b.onMenuShown()});this.addEvent(a,"exportMenuHidden",function(){b.onMenuHidden()});this.createProxyGroup()},onMenuHidden:function(){var a=this.chart.exportContextMenu;a&&a.setAttribute("aria-hidden","true");this.isExportMenuShown=!1;this.setExportButtonExpandedState("false")},onMenuShown:function(){var a=this.chart,b=a.exportContextMenu;b&&(this.addAccessibleContextMenuAttribs(),k(a,b));this.isExportMenuShown=!0;this.setExportButtonExpandedState("true")},setExportButtonExpandedState:function(a){this.exportButtonProxy&&
this.exportButtonProxy.buttonElement.setAttribute("aria-expanded",a)},onChartRender:function(){this.proxyProvider.clearGroup("chartMenu");this.proxyMenuButton()},proxyMenuButton:function(){var a=this.chart,b=this.proxyProvider,c=a.exportSVGElements&&a.exportSVGElements[0],d=a.options.exporting,e=a.exportSVGElements&&a.exportSVGElements[0];d&&!1!==d.enabled&&d.accessibility&&d.accessibility.enabled&&e&&e.element&&c&&(this.exportButtonProxy=b.addProxyElement("chartMenu",{click:c},{"aria-label":a.langFormat("accessibility.exporting.menuButtonLabel",
{chart:a,chartTitle:w(a)}),"aria-expanded":!1}))},createProxyGroup:function(){this.chart&&this.proxyProvider&&this.proxyProvider.addGroup("chartMenu","div")},addAccessibleContextMenuAttribs:function(){var a=this.chart,b=a.exportDivElements;b&&b.length&&(b.forEach(function(b){b&&("LI"!==b.tagName||b.children&&b.children.length?b.setAttribute("aria-hidden","true"):b.setAttribute("tabindex",-1))}),(b=b[0]&&b[0].parentNode)&&m(b,{"aria-hidden":void 0,"aria-label":a.langFormat("accessibility.exporting.chartMenuLabel",
{chart:a}),role:"list"}))},getKeyboardNavigation:function(){var a=this.keyCodes,b=this.chart,c=this;return new q(b,{keyCodeMap:[[[a.left,a.up],function(){return c.onKbdPrevious(this)}],[[a.right,a.down],function(){return c.onKbdNext(this)}],[[a.enter,a.space],function(){return c.onKbdClick(this)}]],validate:function(){return!!b.exporting&&!1!==b.options.exporting.enabled&&!1!==b.options.exporting.accessibility.enabled},init:function(){var a=c.exportButtonProxy,e=c.chart.exportingGroup;a&&e&&b.setFocusToElement(e,
a.buttonElement)},terminate:function(){b.hideExportMenu()}})},onKbdPrevious:function(a){var b=this.chart,c=b.options.accessibility;a=a.response;for(var d=b.highlightedExportItemIx||0;d--;)if(b.highlightExportItem(d))return a.success;return c.keyboardNavigation.wrapAround?(b.highlightLastExportItem(),a.success):a.prev},onKbdNext:function(a){var b=this.chart,c=b.options.accessibility;a=a.response;for(var d=(b.highlightedExportItemIx||0)+1;d<b.exportDivElements.length;++d)if(b.highlightExportItem(d))return a.success;
return c.keyboardNavigation.wrapAround?(b.highlightExportItem(0),a.success):a.next},onKbdClick:function(a){var b=this.chart,c=b.exportDivElements[b.highlightedExportItemIx],d=(b.exportSVGElements&&b.exportSVGElements[0]).element;this.isExportMenuShown?this.fakeClickEvent(c):(this.fakeClickEvent(d),b.highlightExportItem(0));return a.response.success}});return a});u(a,"Accessibility/Components/SeriesComponent/SeriesDescriber.js",[a["Accessibility/Components/AnnotationsA11y.js"],a["Accessibility/Utils/ChartUtilities.js"],
a["Core/FormatUtilities.js"],a["Accessibility/Utils/HTMLUtilities.js"],a["Core/Utilities.js"]],function(a,h,p,q,l){function m(b){var a=b.index;return b.series&&b.series.data&&t(a)?D(b.series.data,function(b){return!!(b&&"undefined"!==typeof b.index&&b.index>a&&b.graphic&&b.graphic.element)})||null:null}function z(b){var a=b.chart.options.accessibility.series.pointDescriptionEnabledThreshold;return!!(!1!==a&&b.points&&b.points.length>=a)}function w(b){var a=b.options.accessibility||{};return!z(b)&&
!a.exposeAsGroupOnly}function k(b){var a=b.chart.options.accessibility.keyboardNavigation.seriesNavigation;return!(!b.points||!(b.points.length<a.pointNavigationEnabledThreshold||!1===a.pointNavigationEnabledThreshold))}function g(b,a){var c=b.series,d=c.chart;b=d.options.accessibility.point||{};var e=c.options.accessibility&&c.options.accessibility.point||{};c=c.tooltipOptions||{};d=d.options.lang;return F(a)?I(a,e.valueDecimals||b.valueDecimals||c.valueDecimals||-1,d.decimalPoint,d.accessibility.thousandsSep||
d.thousandsSep):a}function f(b){var a=(b.options.accessibility||{}).description;return a&&b.chart.langFormat("accessibility.series.description",{description:a,series:b})||""}function b(b,a){return b.chart.langFormat("accessibility.series."+a+"Description",{name:L(b[a]),series:b})}function c(b,a,c){var d=a||"",e=c||"";return b.series.pointArrayMap.reduce(function(a,c){a+=a.length?", ":"";var t=g(b,n(b[c],b.options[c]));return a+(c+": "+d+t+e)},"")}function d(b){var a=b.series,d=a.chart,e=b.series;
var y=e.chart;var f=e.options.accessibility;f=f&&f.point&&f.point.valueDescriptionFormat||y.options.accessibility.point.valueDescriptionFormat;e=n(e.xAxis&&e.xAxis.options.accessibility&&e.xAxis.options.accessibility.enabled,!y.angular);if(e){var r=b.series;var k=r.chart;var h=r.options.accessibility&&r.options.accessibility.point||{},l=k.options.accessibility.point||{};(r=r.xAxis&&r.xAxis.dateTime)?(r=r.getXDateFormat(b.x||0,k.options.tooltip.dateTimeLabelFormats),h=h.dateFormatter&&h.dateFormatter(b)||
l.dateFormatter&&l.dateFormatter(b)||h.dateFormat||l.dateFormat||r,k=k.time.dateFormat(h,b.x||0,void 0)):k=void 0;h=(b.series.xAxis||{}).categories&&t(b.category)&&(""+b.category).replace("<br/>"," ");l=b.id&&0>b.id.indexOf("highcharts-");r="x, "+b.x;k=b.name||k||h||(l?b.id:r)}else k="";h=t(b.index)?b.index+1:"";l=b.series;var m=l.chart.options.accessibility.point||{},x=l.chart.options.accessibility&&l.chart.options.accessibility.point||{},p=l.tooltipOptions||{};r=x.valuePrefix||m.valuePrefix||p.valuePrefix||
"";m=x.valueSuffix||m.valueSuffix||p.valueSuffix||"";x=g(b,b["undefined"!==typeof b.value?"value":"y"]);l=b.isNull?l.chart.langFormat("accessibility.series.nullPointValue",{point:b}):l.pointArrayMap?c(b,r,m):r+x+m;y=A(f,{point:b,index:h,xDescription:k,value:l,separator:e?", ":""},y);f=(f=b.options&&b.options.accessibility&&b.options.accessibility.description)?" "+f:"";a=1<d.series.length&&a.name?" "+a.name+".":"";d=b.series.chart;e=C(b);k={point:b,annotations:e};d=e.length?d.langFormat("accessibility.series.pointAnnotationsDescription",
k):"";b.accessibility=b.accessibility||{};b.accessibility.valueDescription=y;return y+f+a+(d?" "+d:"")}function e(b){var a=w(b),c=k(b);(a||c)&&b.points.forEach(function(c){var e;if(!(e=c.graphic&&c.graphic.element)&&(e=c.series&&c.series.is("sunburst"),e=c.isNull&&!e)){var t=c.series,f=m(c);t=(e=f&&f.graphic)?e.parentGroup:t.graph||t.group;f=f?{x:n(c.plotX,f.plotX,0),y:n(c.plotY,f.plotY,0)}:{x:n(c.plotX,0),y:n(c.plotY,0)};f=c.series.chart.renderer.rect(f.x,f.y,1,1);f.attr({"class":"highcharts-a11y-dummy-point",
fill:"none",opacity:0,"fill-opacity":0,"stroke-opacity":0});t&&t.element?(c.graphic=f,c.hasDummyGraphic=!0,f.add(t),t.element.insertBefore(f.element,e?e.element:null),e=f.element):e=void 0}t=c.options&&c.options.accessibility&&!1===c.options.accessibility.enabled;e&&(e.setAttribute("tabindex","-1"),b.chart.styledMode||(e.style.outline="none"),a&&!t?(f=c.series,t=f.chart.options.accessibility.point||{},f=f.options.accessibility&&f.options.accessibility.point||{},c=E(f.descriptionFormatter&&f.descriptionFormatter(c)||
t.descriptionFormatter&&t.descriptionFormatter(c)||d(c)),e.setAttribute("role","img"),e.setAttribute("aria-label",c)):e.setAttribute("aria-hidden",!0))})}function r(a){var c=a.chart,d=c.types||[],e=f(a),t=function(b){return c[b]&&1<c[b].length&&a[b]},y=b(a,"xAxis"),r=b(a,"yAxis"),g={name:a.name||"",ix:a.index+1,numSeries:c.series&&c.series.length,numPoints:a.points&&a.points.length,series:a};d=1<d.length?"Combination":"";return(c.langFormat("accessibility.series.summary."+a.type+d,g)||c.langFormat("accessibility.series.summary.default"+
d,g))+(e?" "+e:"")+(t("yAxis")?" "+r:"")+(t("xAxis")?" "+y:"")}var C=a.getPointAnnotationTexts,L=h.getAxisDescription,B=h.getSeriesFirstPointElement,H=h.getSeriesA11yElement,x=h.unhideChartElementFromAT,A=p.format,I=p.numberFormat,G=q.reverseChildNodes,E=q.stripHTMLTagsFromString,D=l.find,F=l.isNumber,n=l.pick,t=l.defined;return{defaultPointDescriptionFormatter:d,defaultSeriesDescriptionFormatter:r,describeSeries:function(b){var a=b.chart,c=B(b),d=H(b),t=a.is3d&&a.is3d();if(d){d.lastChild!==c||t||
G(d);e(b);x(a,d);t=b.chart;a=t.options.chart;c=1<t.series.length;t=t.options.accessibility.series.describeSingleSeries;var f=(b.options.accessibility||{}).exposeAsGroupOnly;a.options3d&&a.options3d.enabled&&c||!(c||t||f||z(b))?d.setAttribute("aria-label",""):(a=b.chart.options.accessibility,c=a.landmarkVerbosity,(b.options.accessibility||{}).exposeAsGroupOnly?d.setAttribute("role","img"):"all"===c&&d.setAttribute("role","region"),d.setAttribute("tabindex","-1"),b.chart.styledMode||(d.style.outline=
"none"),d.setAttribute("aria-label",E(a.series.descriptionFormatter&&a.series.descriptionFormatter(b)||r(b))))}}}});u(a,"Accessibility/Components/SeriesComponent/NewDataAnnouncer.js",[a["Core/Globals.js"],a["Core/Utilities.js"],a["Accessibility/Utils/Announcer.js"],a["Accessibility/Utils/ChartUtilities.js"],a["Accessibility/Utils/EventProvider.js"],a["Accessibility/Components/SeriesComponent/SeriesDescriber.js"]],function(a,h,p,q,l,v){function m(b){var a=b.series.data.filter(function(a){return b.x===
a.x&&b.y===a.y});return 1===a.length?a[0]:b}function w(b,a){var c=(b||[]).concat(a||[]).reduce(function(b,a){b[a.name+a.index]=a;return b},{});return Object.keys(c).map(function(b){return c[b]})}var k=h.addEvent,g=h.defined,f=q.getChartTitle,b=v.defaultPointDescriptionFormatter,c=v.defaultSeriesDescriptionFormatter;h=function(){function d(b){this.announcer=void 0;this.dirty={allSeries:{}};this.eventProvider=void 0;this.lastAnnouncementTime=0;this.chart=b}d.prototype.init=function(){var b=this.chart,
a=b.options.accessibility.announceNewData.interruptUser?"assertive":"polite";this.lastAnnouncementTime=0;this.dirty={allSeries:{}};this.eventProvider=new l;this.announcer=new p(b,a);this.addEventListeners()};d.prototype.destroy=function(){this.eventProvider.removeAddedEvents();this.announcer.destroy()};d.prototype.addEventListeners=function(){var b=this,a=this.chart,c=this.eventProvider;c.addEvent(a,"afterDrilldown",function(){b.lastAnnouncementTime=0});c.addEvent(a,"afterAddSeries",function(a){b.onSeriesAdded(a.series)});
c.addEvent(a,"redraw",function(){b.announceDirtyData()})};d.prototype.onSeriesAdded=function(b){this.chart.options.accessibility.announceNewData.enabled&&(this.dirty.hasDirty=!0,this.dirty.allSeries[b.name+b.index]=b,this.dirty.newSeries=g(this.dirty.newSeries)?void 0:b)};d.prototype.announceDirtyData=function(){var b=this;if(this.chart.options.accessibility.announceNewData&&this.dirty.hasDirty){var a=this.dirty.newPoint;a&&(a=m(a));this.queueAnnouncement(Object.keys(this.dirty.allSeries).map(function(a){return b.dirty.allSeries[a]}),
this.dirty.newSeries,a);this.dirty={allSeries:{}}}};d.prototype.queueAnnouncement=function(b,a,c){var d=this,e=this.chart.options.accessibility.announceNewData;if(e.enabled){var f=+new Date;e=Math.max(0,e.minAnnounceInterval-(f-this.lastAnnouncementTime));b=w(this.queuedAnnouncement&&this.queuedAnnouncement.series,b);if(a=this.buildAnnouncementMessage(b,a,c))this.queuedAnnouncement&&clearTimeout(this.queuedAnnouncementTimer),this.queuedAnnouncement={time:f,message:a,series:b},this.queuedAnnouncementTimer=
setTimeout(function(){d&&d.announcer&&(d.lastAnnouncementTime=+new Date,d.announcer.announce(d.queuedAnnouncement.message),delete d.queuedAnnouncement,delete d.queuedAnnouncementTimer)},e)}};d.prototype.buildAnnouncementMessage=function(d,r,g){var e=this.chart,k=e.options.accessibility.announceNewData;if(k.announcementFormatter&&(d=k.announcementFormatter(d,r,g),!1!==d))return d.length?d:null;d=a.charts&&1<a.charts.length?"Multiple":"Single";d=r?"newSeriesAnnounce"+d:g?"newPointAnnounce"+d:"newDataAnnounce";
k=f(e);return e.langFormat("accessibility.announceNewData."+d,{chartTitle:k,seriesDesc:r?c(r):null,pointDesc:g?b(g):null,point:g,series:r})};return d}();(function(b){function a(b){var a=this.chart,c=this.newDataAnnouncer;c&&c.chart===a&&a.options.accessibility.announceNewData.enabled&&(c.dirty.newPoint=g(c.dirty.newPoint)?void 0:b.point)}function c(){var b=this.chart,a=this.newDataAnnouncer;a&&a.chart===b&&b.options.accessibility.announceNewData.enabled&&(a.dirty.hasDirty=!0,a.dirty.allSeries[this.name+
this.index]=this)}b.composedClasses=[];b.compose=function(d){-1===b.composedClasses.indexOf(d)&&(b.composedClasses.push(d),k(d,"addPoint",a),k(d,"updatedData",c))}})(h||(h={}));return h});u(a,"Accessibility/ProxyElement.js",[a["Core/Globals.js"],a["Core/Utilities.js"],a["Accessibility/Utils/EventProvider.js"],a["Accessibility/Utils/ChartUtilities.js"],a["Accessibility/Utils/HTMLUtilities.js"]],function(a,h,p,q,l){var m=a.doc,z=h.attr,w=h.css,k=h.merge,g=q.fireEventOnWrappedOrUnwrappedElement,f=l.cloneMouseEvent,
b=l.cloneTouchEvent,c=l.getFakeMouseEvent,d=l.removeElement;return function(){function a(b,a,c,d){this.chart=b;this.target=a;this.groupType=c;this.eventProvider=new p;c="ul"===c?m.createElement("li"):null;var e=this.buttonElement=m.createElement("button");b.styledMode||this.hideButtonVisually(e);c?(c.appendChild(e),this.element=c):this.element=e;this.updateTarget(a,d)}a.prototype.click=function(){var b=this.getTargetPosition();b.x+=b.width/2;b.y+=b.height/2;b=c("click",b);g(this.target.click,b)};
a.prototype.updateTarget=function(b,a){this.target=b;this.updateCSSClassName();z(this.buttonElement,k({"aria-label":this.getTargetAttr(b.click,"aria-label")},a));this.eventProvider.removeAddedEvents();this.addProxyEventsToButton(this.buttonElement,b.click);this.refreshPosition()};a.prototype.refreshPosition=function(){var b=this.getTargetPosition();w(this.buttonElement,{width:(b.width||1)+"px",height:(b.height||1)+"px",left:(Math.round(b.x)||0)+"px",top:(Math.round(b.y)||0)+"px"})};a.prototype.remove=
function(){this.eventProvider.removeAddedEvents();d(this.element)};a.prototype.updateCSSClassName=function(){var b=this.chart.legend;b=b.group&&b.group.div;b=-1<(b&&b.className||"").indexOf("highcharts-no-tooltip");var a=-1<(this.getTargetAttr(this.target.click,"class")||"").indexOf("highcharts-no-tooltip");this.buttonElement.className=b||a?"highcharts-a11y-proxy-button highcharts-no-tooltip":"highcharts-a11y-proxy-button"};a.prototype.addProxyEventsToButton=function(a,c){var d=this;"click touchstart touchend touchcancel touchmove mouseover mouseenter mouseleave mouseout".split(" ").forEach(function(e){var k=
0===e.indexOf("touch");d.eventProvider.addEvent(a,e,function(a){var d=k?b(a):f(a);c&&g(c,d);a.stopPropagation();k||a.preventDefault()},{passive:!1})})};a.prototype.hideButtonVisually=function(b){w(b,{borderWidth:0,backgroundColor:"transparent",cursor:"pointer",outline:"none",opacity:.001,filter:"alpha(opacity=1)",zIndex:999,overflow:"hidden",padding:0,margin:0,display:"block",position:"absolute","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=1)"})};a.prototype.getTargetPosition=function(){var b=
this.target.click;b=b.element?b.element:b;var a=this.target.visual||b;return(b=this.chart.renderTo)&&a&&a.getBoundingClientRect?(a=a.getBoundingClientRect(),b=b.getBoundingClientRect(),{x:a.left-b.left,y:a.top-b.top,width:a.right-a.left,height:a.bottom-a.top}):{x:0,y:0,width:1,height:1}};a.prototype.getTargetAttr=function(b,a){return b.element?b.element.getAttribute(a):b.getAttribute(a)};return a}()});u(a,"Accessibility/ProxyProvider.js",[a["Core/Globals.js"],a["Core/Utilities.js"],a["Accessibility/Utils/ChartUtilities.js"],
a["Accessibility/Utils/DOMElementProvider.js"],a["Accessibility/Utils/HTMLUtilities.js"],a["Accessibility/ProxyElement.js"]],function(a,h,p,q,l,v){var m=a.doc,w=h.attr,k=h.css,g=p.unhideChartElementFromAT,f=l.removeElement,b=l.removeChildNodes;return function(){function a(b){this.chart=b;this.domElementProvider=new q;this.groups={};this.groupOrder=[];this.beforeChartProxyPosContainer=this.createProxyPosContainer("before");this.afterChartProxyPosContainer=this.createProxyPosContainer("after");this.update()}
a.prototype.addProxyElement=function(b,a,c){var d=this.groups[b];if(!d)throw Error("ProxyProvider.addProxyElement: Invalid group key "+b);b=new v(this.chart,a,d.type,c);d.proxyContainerElement.appendChild(b.element);d.proxyElements.push(b);return b};a.prototype.addGroup=function(b,a,c){if(!this.groups[b]){var d=this.domElementProvider.createElement(a);if(c&&c.role&&"div"!==a){var e=this.domElementProvider.createElement("div");e.appendChild(d)}else e=d;e.className="highcharts-a11y-proxy-group highcharts-a11y-proxy-group-"+
b.replace(/\W/g,"-");this.groups[b]={proxyContainerElement:d,groupElement:e,type:a,proxyElements:[]};w(e,c||{});"ul"===a&&(this.chart.styledMode||(d.style.listStyle="none"),d.setAttribute("role","list"));this.afterChartProxyPosContainer.appendChild(e);this.updateGroupOrder(this.groupOrder)}};a.prototype.updateGroupAttrs=function(b,a){var c=this.groups[b];if(!c)throw Error("ProxyProvider.updateGroupAttrs: Invalid group key "+b);w(c.groupElement,a)};a.prototype.updateGroupOrder=function(a){var c=this;
this.groupOrder=a.slice();if(!this.isDOMOrderGroupOrder()){var d=a.indexOf("series"),f=-1<d?a.slice(0,d):a,g=-1<d?a.slice(d+1):[];a=m.activeElement;["before","after"].forEach(function(a){var d=c["before"===a?"beforeChartProxyPosContainer":"afterChartProxyPosContainer"];a="before"===a?f:g;b(d);a.forEach(function(b){(b=c.groups[b])&&d.appendChild(b.groupElement)})});(this.beforeChartProxyPosContainer.contains(a)||this.afterChartProxyPosContainer.contains(a))&&a&&a.focus&&a.focus()}};a.prototype.clearGroup=
function(a){var c=this.groups[a];if(!c)throw Error("ProxyProvider.clearGroup: Invalid group key "+a);b(c.proxyContainerElement)};a.prototype.removeGroup=function(b){var a=this.groups[b];a&&(f(a.groupElement),delete this.groups[b])};a.prototype.update=function(){this.updatePosContainerPositions();this.updateGroupOrder(this.groupOrder);this.updateProxyElementPositions()};a.prototype.updateProxyElementPositions=function(){Object.keys(this.groups).forEach(this.updateGroupProxyElementPositions.bind(this))};
a.prototype.updateGroupProxyElementPositions=function(b){(b=this.groups[b])&&b.proxyElements.forEach(function(b){return b.refreshPosition()})};a.prototype.destroy=function(){this.domElementProvider.destroyCreatedElements()};a.prototype.createProxyPosContainer=function(b){var a=this.domElementProvider.createElement("div");a.setAttribute("aria-hidden","false");a.className="highcharts-a11y-proxy-container"+(b?"-"+b:"");k(a,{top:"0",left:"0"});this.chart.styledMode||(a.style.whiteSpace="nowrap",a.style.position=
"absolute");return a};a.prototype.getCurrentGroupOrderInDOM=function(){var b=this,a=function(a){var c=[];a=a.children;for(var d=0;d<a.length;++d){a:{var e=a[d];for(var f=Object.keys(b.groups),g=f.length;g--;){var k=f[g],h=b.groups[k];if(h&&e===h.groupElement){e=k;break a}}e=void 0}e&&c.push(e)}return c},c=a(this.beforeChartProxyPosContainer);a=a(this.afterChartProxyPosContainer);c.push("series");return c.concat(a)};a.prototype.isDOMOrderGroupOrder=function(){var b=this,a=this.getCurrentGroupOrderInDOM(),
c=this.groupOrder.filter(function(a){return"series"===a||!!b.groups[a]}),f=a.length;if(f!==c.length)return!1;for(;f--;)if(a[f]!==c[f])return!1;return!0};a.prototype.updatePosContainerPositions=function(){var b=this.chart,a=b.renderer.box;b.container.insertBefore(this.afterChartProxyPosContainer,a.nextSibling);b.container.insertBefore(this.beforeChartProxyPosContainer,a);g(this.chart,this.afterChartProxyPosContainer);g(this.chart,this.beforeChartProxyPosContainer)};return a}()});u(a,"Extensions/RangeSelector.js",
[a["Core/Axis/Axis.js"],a["Core/Chart/Chart.js"],a["Core/Globals.js"],a["Core/DefaultOptions.js"],a["Core/Renderer/SVG/SVGElement.js"],a["Core/Utilities.js"]],function(a,h,p,q,l,v){function m(b){if(-1!==b.indexOf("%L"))return"text";var a="aAdewbBmoyY".split("").some(function(a){return-1!==b.indexOf("%"+a)}),c="HkIlMS".split("").some(function(a){return-1!==b.indexOf("%"+a)});return a&&c?"datetime-local":a?"date":c?"time":"text"}var w=q.defaultOptions,k=v.addEvent,g=v.createElement,f=v.css,b=v.defined,
c=v.destroyObjectProperties,d=v.discardElement,e=v.extend,r=v.find,C=v.fireEvent,u=v.isNumber,B=v.merge,H=v.objectEach,x=v.pad,A=v.pick,I=v.pInt,G=v.splat;e(w,{rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",
inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:"#335cad",cursor:"pointer"},labelStyle:{color:"#666666"}}});e(w.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"\u2192"});var E=function(){function n(b){this.buttons=void 0;this.buttonOptions=n.prototype.defaultButtons;this.initialButtonGroupWidth=0;this.options=void 0;this.chart=b;this.init(b)}n.prototype.clickButton=function(c,d){var e=
this.chart,t=this.buttonOptions[c],f=e.xAxis[0],y=e.scroller&&e.scroller.getUnionExtremes()||f||{},g=y.dataMin,n=y.dataMax,h=f&&Math.round(Math.min(f.max,A(n,f.max))),l=t.type;y=t._range;var r,m=t.dataGrouping;if(null!==g&&null!==n){e.fixedRange=y;this.setSelected(c);m&&(this.forcedDataGrouping=!0,a.prototype.setDataGrouping.call(f||{chart:this.chart},m,!1),this.frozenStates=t.preserveDataGrouping);if("month"===l||"year"===l)if(f){l={range:t,max:h,chart:e,dataMin:g,dataMax:n};var p=f.minFromRange.call(l);
u(l.newMax)&&(h=l.newMax)}else y=t;else if(y)p=Math.max(h-y,g),h=Math.min(p+y,n);else if("ytd"===l)if(f)"undefined"===typeof n&&(g=Number.MAX_VALUE,n=Number.MIN_VALUE,e.series.forEach(function(b){b=b.xData;g=Math.min(b[0],g);n=Math.max(b[b.length-1],n)}),d=!1),h=this.getYTDExtremes(n,g,e.time.useUTC),p=r=h.min,h=h.max;else{this.deferredYTDClick=c;return}else"all"===l&&f&&(e.navigator&&e.navigator.baseSeries[0]&&(e.navigator.baseSeries[0].xAxis.options.range=void 0),p=g,h=n);b(p)&&(p+=t._offsetMin);
b(h)&&(h+=t._offsetMax);this.dropdown&&(this.dropdown.selectedIndex=c+1);if(f)f.setExtremes(p,h,A(d,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:t});else{var x=G(e.options.xAxis)[0];var q=x.range;x.range=y;var w=x.min;x.min=r;k(e,"load",function(){x.range=q;x.min=w})}C(this,"afterBtnClick")}};n.prototype.setSelected=function(b){this.selected=this.options.selected=b};n.prototype.init=function(b){var a=this,c=b.options.rangeSelector,d=c.buttons||a.defaultButtons.slice(),e=c.selected,
f=function(){var b=a.minInput,c=a.maxInput;b&&b.blur&&C(b,"blur");c&&c.blur&&C(c,"blur")};a.chart=b;a.options=c;a.buttons=[];a.buttonOptions=d;this.eventsToUnbind=[];this.eventsToUnbind.push(k(b.container,"mousedown",f));this.eventsToUnbind.push(k(b,"resize",f));d.forEach(a.computeButtonRange);"undefined"!==typeof e&&d[e]&&this.clickButton(e,!1);this.eventsToUnbind.push(k(b,"load",function(){b.xAxis&&b.xAxis[0]&&k(b.xAxis[0],"setExtremes",function(c){this.max-this.min!==b.fixedRange&&"rangeSelectorButton"!==
c.trigger&&"updatedData"!==c.trigger&&a.forcedDataGrouping&&!a.frozenStates&&this.setDataGrouping(!1,!1)})}))};n.prototype.updateButtonStates=function(){var b=this,a=this.chart,c=this.dropdown,d=a.xAxis[0],e=Math.round(d.max-d.min),f=!d.hasVisibleSeries,g=a.scroller&&a.scroller.getUnionExtremes()||d,n=g.dataMin,k=g.dataMax;a=b.getYTDExtremes(k,n,a.time.useUTC);var h=a.min,l=a.max,r=b.selected,m=u(r),A=b.options.allButtonsEnabled,p=b.buttons;b.buttonOptions.forEach(function(a,t){var g=a._range,y=a.type,
K=a.count||1,M=p[t],J=0,N=a._offsetMax-a._offsetMin;a=t===r;var x=g>k-n,q=g<d.minRange,w=!1,O=!1;g=g===e;("month"===y||"year"===y)&&e+36E5>=864E5*{month:28,year:365}[y]*K-N&&e-36E5<=864E5*{month:31,year:366}[y]*K+N?g=!0:"ytd"===y?(g=l-h+N===e,w=!a):"all"===y&&(g=d.max-d.min>=k-n,O=!a&&m&&g);y=!A&&(x||q||O||f);K=a&&g||g&&!m&&!w||a&&b.frozenStates;y?J=3:K&&(m=!0,J=2);M.state!==J&&(M.setState(J),c&&(c.options[t+1].disabled=y,2===J&&(c.selectedIndex=t+1)),0===J&&r===t&&b.setSelected())})};n.prototype.computeButtonRange=
function(b){var a=b.type,c=b.count||1,d={millisecond:1,second:1E3,minute:6E4,hour:36E5,day:864E5,week:6048E5};if(d[a])b._range=d[a]*c;else if("month"===a||"year"===a)b._range=864E5*{month:30,year:365}[a]*c;b._offsetMin=A(b.offsetMin,0);b._offsetMax=A(b.offsetMax,0);b._range+=b._offsetMax-b._offsetMin};n.prototype.getInputValue=function(b){b="min"===b?this.minInput:this.maxInput;var a=this.chart.options.rangeSelector,c=this.chart.time;return b?("text"===b.type&&a.inputDateParser||this.defaultInputDateParser)(b.value,
c.useUTC,c):0};n.prototype.setInputValue=function(a,c){var d=this.options,e=this.chart.time,f="min"===a?this.minInput:this.maxInput;a="min"===a?this.minDateBox:this.maxDateBox;if(f){var t=f.getAttribute("data-hc-time");t=b(t)?Number(t):void 0;b(c)&&(b(t)&&f.setAttribute("data-hc-time-previous",t),f.setAttribute("data-hc-time",c),t=c);f.value=e.dateFormat(this.inputTypeFormats[f.type]||d.inputEditDateFormat,t);a&&a.attr({text:e.dateFormat(d.inputDateFormat,t)})}};n.prototype.setInputExtremes=function(b,
a,c){if(b="min"===b?this.minInput:this.maxInput){var d=this.inputTypeFormats[b.type],e=this.chart.time;d&&(a=e.dateFormat(d,a),b.min!==a&&(b.min=a),c=e.dateFormat(d,c),b.max!==c&&(b.max=c))}};n.prototype.showInput=function(b){var a="min"===b?this.minDateBox:this.maxDateBox;if((b="min"===b?this.minInput:this.maxInput)&&a&&this.inputGroup){var c="text"===b.type,d=this.inputGroup,e=d.translateX;d=d.translateY;var t=this.options.inputBoxWidth;f(b,{width:c?a.width+(t?-2:20)+"px":"auto",height:c?a.height-
2+"px":"auto",border:"2px solid silver"});c&&t?f(b,{left:e+a.x+"px",top:d+"px"}):f(b,{left:Math.min(Math.round(a.x+e-(b.offsetWidth-a.width)/2),this.chart.chartWidth-b.offsetWidth)+"px",top:d-(b.offsetHeight-a.height)/2+"px"})}};n.prototype.hideInput=function(b){(b="min"===b?this.minInput:this.maxInput)&&f(b,{top:"-9999em",border:0,width:"1px",height:"1px"})};n.prototype.defaultInputDateParser=function(b,a,c){var d=b.split("/").join("-").split(" ").join("T");-1===d.indexOf("T")&&(d+="T00:00");if(a)d+=
"Z";else{var e;if(e=p.isSafari)e=d,e=!(6<e.length&&(e.lastIndexOf("-")===e.length-6||e.lastIndexOf("+")===e.length-6));e&&(e=(new Date(d)).getTimezoneOffset()/60,d+=0>=e?"+"+x(-e)+":00":"-"+x(e)+":00")}d=Date.parse(d);u(d)||(b=b.split("-"),d=Date.UTC(I(b[0]),I(b[1])-1,I(b[2])));c&&a&&u(d)&&(d+=c.getTimezoneOffset(d));return d};n.prototype.drawInput=function(b){function a(){var a=n.getInputValue(b),d=c.xAxis[0],e=c.scroller&&c.scroller.xAxis?c.scroller.xAxis:d,f=e.dataMin;e=e.dataMax;var t=n.maxInput,
g=n.minInput;a!==Number(x.getAttribute("data-hc-time-previous"))&&u(a)&&(x.setAttribute("data-hc-time-previous",a),r&&t&&u(f)?a>Number(t.getAttribute("data-hc-time"))?a=void 0:a<f&&(a=f):g&&u(e)&&(a<Number(g.getAttribute("data-hc-time"))?a=void 0:a>e&&(a=e)),"undefined"!==typeof a&&d.setExtremes(r?a:d.min,r?d.max:a,void 0,void 0,{trigger:"rangeSelectorInput"}))}var c=this.chart,d=this.div,t=this.inputGroup,n=this,k=c.renderer.style||{},h=c.renderer,l=c.options.rangeSelector,r="min"===b,A=w.lang[r?
"rangeSelectorFrom":"rangeSelectorTo"]||"";A=h.label(A,0).addClass("highcharts-range-label").attr({padding:A?2:0,height:A?l.inputBoxHeight:0}).add(t);h=h.label("",0).addClass("highcharts-range-input").attr({padding:2,width:l.inputBoxWidth,height:l.inputBoxHeight,"text-align":"center"}).on("click",function(){n.showInput(b);n[b+"Input"].focus()});c.styledMode||h.attr({stroke:l.inputBoxBorderColor,"stroke-width":1});h.add(t);var x=g("input",{name:b,className:"highcharts-range-selector"},void 0,d);x.setAttribute("type",
m(l.inputDateFormat||"%b %e, %Y"));c.styledMode||(A.css(B(k,l.labelStyle)),h.css(B({color:"#333333"},k,l.inputStyle)),f(x,e({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:k.fontSize,fontFamily:k.fontFamily,top:"-9999em"},l.inputStyle)));x.onfocus=function(){n.showInput(b)};x.onblur=function(){x===p.doc.activeElement&&a();n.hideInput(b);n.setInputValue(b);x.blur()};var q=!1;x.onchange=function(){q||(a(),n.hideInput(b),
x.blur())};x.onkeypress=function(b){13===b.keyCode&&a()};x.onkeydown=function(b){q=!0;38!==b.keyCode&&40!==b.keyCode||a()};x.onkeyup=function(){q=!1};return{dateBox:h,input:x,label:A}};n.prototype.getPosition=function(){var b=this.chart,a=b.options.rangeSelector;b="top"===a.verticalAlign?b.plotTop-b.axisOffset[0]:0;return{buttonTop:b+a.buttonPosition.y,inputTop:b+a.inputPosition.y-10}};n.prototype.getYTDExtremes=function(b,a,c){var d=this.chart.time,e=new d.Date(b),f=d.get("FullYear",e);c=c?d.Date.UTC(f,
0,1):+new d.Date(f,0,1);a=Math.max(a,c);e=e.getTime();return{max:Math.min(b||e,e),min:a}};n.prototype.render=function(a,c){var d=this.chart,e=d.renderer,f=d.container,t=d.options,n=t.rangeSelector,k=A(t.chart.style&&t.chart.style.zIndex,0)+1;t=n.inputEnabled;if(!1!==n.enabled){this.rendered||(this.group=e.g("range-selector-group").attr({zIndex:7}).add(),this.div=g("div",void 0,{position:"relative",height:0,zIndex:k}),this.buttonOptions.length&&this.renderButtons(),f.parentNode&&f.parentNode.insertBefore(this.div,
f),t&&(this.inputGroup=e.g("input-group").add(this.group),e=this.drawInput("min"),this.minDateBox=e.dateBox,this.minLabel=e.label,this.minInput=e.input,e=this.drawInput("max"),this.maxDateBox=e.dateBox,this.maxLabel=e.label,this.maxInput=e.input));if(t&&(this.setInputValue("min",a),this.setInputValue("max",c),a=d.scroller&&d.scroller.getUnionExtremes()||d.xAxis[0]||{},b(a.dataMin)&&b(a.dataMax)&&(d=d.xAxis[0].minRange||0,this.setInputExtremes("min",a.dataMin,Math.min(a.dataMax,this.getInputValue("max"))-
d),this.setInputExtremes("max",Math.max(a.dataMin,this.getInputValue("min"))+d,a.dataMax)),this.inputGroup)){var h=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(b){if(b){var a=b.getBBox().width;a&&(b.attr({x:h}),h+=a+n.inputSpacing)}})}this.alignElements();this.rendered=!0}};n.prototype.renderButtons=function(){var b=this,a=this.buttons,c=this.options,d=w.lang,e=this.chart.renderer,f=B(c.buttonTheme),n=f&&f.states,h=f.width||28;delete f.width;delete f.states;this.buttonGroup=
e.g("range-selector-buttons").add(this.group);var l=this.dropdown=g("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:.0001},this.div);k(l,"touchstart",function(){l.style.fontSize="16px"});[[p.isMS?"mouseover":"mouseenter"],[p.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(c){var d=c[0],e=c[1];k(l,d,function(){var c=a[b.currentButtonIndex()];c&&C(c.element,e||d)})});this.zoomText=e.label(d&&d.rangeSelectorZoom||
"",0).attr({padding:c.buttonTheme.padding,height:c.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup);this.chart.styledMode||(this.zoomText.css(c.labelStyle),f["stroke-width"]=A(f["stroke-width"],0));g("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,l);this.buttonOptions.forEach(function(c,d){g("option",{textContent:c.title||c.text},void 0,l);a[d]=e.button(c.text,0,0,function(a){var e=c.events&&c.events.click,f;e&&(f=e.call(c,a));!1!==f&&b.clickButton(d);b.isActive=
!0},f,n&&n.hover,n&&n.select,n&&n.disabled).attr({"text-align":"center",width:h}).add(b.buttonGroup);c.title&&a[d].attr("title",c.title)})};n.prototype.alignElements=function(){var b=this,a=this.buttonGroup,c=this.buttons,d=this.chart,e=this.group,f=this.inputGroup,g=this.options,n=this.zoomText,k=d.options,h=k.exporting&&!1!==k.exporting.enabled&&k.navigation&&k.navigation.buttonOptions;k=g.buttonPosition;var l=g.inputPosition,r=g.verticalAlign,m=function(a,c){return h&&b.titleCollision(d)&&"top"===
r&&"right"===c.align&&c.y-a.getBBox().height-12<(h.y||0)+(h.height||0)+d.spacing[0]?-40:0},x=d.plotLeft;if(e&&k&&l){var p=k.x-d.spacing[3];if(a){this.positionButtons();if(!this.initialButtonGroupWidth){var q=0;n&&(q+=n.getBBox().width+5);c.forEach(function(b,a){q+=b.width;a!==c.length-1&&(q+=g.buttonSpacing)});this.initialButtonGroupWidth=q}x-=d.spacing[3];this.updateButtonStates();n=m(a,k);this.alignButtonGroup(n);e.placed=a.placed=d.hasLoaded}a=0;f&&(a=m(f,l),"left"===l.align?p=x:"right"===l.align&&
(p=-Math.max(d.axisOffset[1],-a)),f.align({y:l.y,width:f.getBBox().width,align:l.align,x:l.x+p-2},!0,d.spacingBox),f.placed=d.hasLoaded);this.handleCollision(a);e.align({verticalAlign:r},!0,d.spacingBox);f=e.alignAttr.translateY;a=e.getBBox().height+20;m=0;"bottom"===r&&(m=(m=d.legend&&d.legend.options)&&"bottom"===m.verticalAlign&&m.enabled&&!m.floating?d.legend.legendHeight+A(m.margin,10):0,a=a+m-20,m=f-a-(g.floating?0:g.y)-(d.titleOffset?d.titleOffset[2]:0)-10);if("top"===r)g.floating&&(m=0),d.titleOffset&&
d.titleOffset[0]&&(m=d.titleOffset[0]),m+=d.margin[0]-d.spacing[0]||0;else if("middle"===r)if(l.y===k.y)m=f;else if(l.y||k.y)m=0>l.y||0>k.y?m-Math.min(l.y,k.y):f-a;e.translate(g.x,g.y+Math.floor(m));k=this.minInput;l=this.maxInput;f=this.dropdown;g.inputEnabled&&k&&l&&(k.style.marginTop=e.translateY+"px",l.style.marginTop=e.translateY+"px");f&&(f.style.marginTop=e.translateY+"px")}};n.prototype.alignButtonGroup=function(b,a){var c=this.chart,d=this.buttonGroup,e=this.options.buttonPosition,f=c.plotLeft-
c.spacing[3],g=e.x-c.spacing[3];"right"===e.align?g+=b-f:"center"===e.align&&(g-=f/2);d&&d.align({y:e.y,width:A(a,this.initialButtonGroupWidth),align:e.align,x:g},!0,c.spacingBox)};n.prototype.positionButtons=function(){var b=this.buttons,a=this.chart,c=this.options,d=this.zoomText,e=a.hasLoaded?"animate":"attr",f=c.buttonPosition,g=a.plotLeft,n=g;d&&"hidden"!==d.visibility&&(d[e]({x:A(g+f.x,g)}),n+=f.x+d.getBBox().width+5);this.buttonOptions.forEach(function(a,d){if("hidden"!==b[d].visibility)b[d][e]({x:n}),
n+=b[d].width+c.buttonSpacing;else b[d][e]({x:g})})};n.prototype.handleCollision=function(b){var a=this,c=this.chart,d=this.buttonGroup,e=this.inputGroup,f=this.options,g=f.buttonPosition,n=f.dropdown,t=f.inputPosition;f=function(){var b=0;a.buttons.forEach(function(a){a=a.getBBox();a.width>b&&(b=a.width)});return b};var k=function(a){if(e&&d){var c=e.alignAttr.translateX+e.alignOptions.x-b+e.getBBox().x+2,f=e.alignOptions.width,n=d.alignAttr.translateX+d.getBBox().x;return n+a>c&&c+f>n&&g.y<t.y+
e.getBBox().height}return!1},h=function(){e&&d&&e.attr({translateX:e.alignAttr.translateX+(c.axisOffset[1]>=-b?0:-b),translateY:e.alignAttr.translateY+d.getBBox().height+10})};if(d){if("always"===n){this.collapseButtons(b);k(f())&&h();return}"never"===n&&this.expandButtons()}e&&d?t.align===g.align||k(this.initialButtonGroupWidth+20)?"responsive"===n?(this.collapseButtons(b),k(f())&&h()):h():"responsive"===n&&this.expandButtons():d&&"responsive"===n&&(this.initialButtonGroupWidth>c.plotWidth?this.collapseButtons(b):
this.expandButtons())};n.prototype.collapseButtons=function(b){var a=this.buttons,c=this.buttonOptions,d=this.chart,e=this.dropdown,f=this.options,g=this.zoomText,n=d.userOptions.rangeSelector&&d.userOptions.rangeSelector.buttonTheme||{},k=function(b){return{text:b?b+" \u25be":"\u25be",width:"auto",paddingLeft:A(f.buttonTheme.paddingLeft,n.padding,8),paddingRight:A(f.buttonTheme.paddingRight,n.padding,8)}};g&&g.hide();var t=!1;c.forEach(function(b,c){c=a[c];2!==c.state?c.hide():(c.show(),c.attr(k(b.text)),
t=!0)});t||(e&&(e.selectedIndex=0),a[0].show(),a[0].attr(k(this.zoomText&&this.zoomText.textStr)));c=f.buttonPosition.align;this.positionButtons();"right"!==c&&"center"!==c||this.alignButtonGroup(b,a[this.currentButtonIndex()].getBBox().width);this.showDropdown()};n.prototype.expandButtons=function(){var b=this.buttons,a=this.buttonOptions,c=this.options,d=this.zoomText;this.hideDropdown();d&&d.show();a.forEach(function(a,d){d=b[d];d.show();d.attr({text:a.text,width:c.buttonTheme.width||28,paddingLeft:A(c.buttonTheme.paddingLeft,
"unset"),paddingRight:A(c.buttonTheme.paddingRight,"unset")});2>d.state&&d.setState(0)});this.positionButtons()};n.prototype.currentButtonIndex=function(){var b=this.dropdown;return b&&0<b.selectedIndex?b.selectedIndex-1:0};n.prototype.showDropdown=function(){var b=this.buttonGroup,a=this.buttons,c=this.chart,d=this.dropdown;if(b&&d){var e=b.translateX;b=b.translateY;a=a[this.currentButtonIndex()].getBBox();f(d,{left:c.plotLeft+e+"px",top:b+.5+"px",width:a.width+"px",height:a.height+"px"});this.hasVisibleDropdown=
!0}};n.prototype.hideDropdown=function(){var b=this.dropdown;b&&(f(b,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)};n.prototype.getHeight=function(){var b=this.options,a=this.group,c=b.y,d=b.buttonPosition.y,e=b.inputPosition.y;if(b.height)return b.height;this.alignElements();b=a?a.getBBox(!0).height+13+c:0;a=Math.min(e,d);if(0>e&&0>d||0<e&&0<d)b+=Math.abs(a);return b};n.prototype.titleCollision=function(b){return!(b.options.title.text||b.options.subtitle.text)};n.prototype.update=
function(b){var a=this.chart;B(!0,a.options.rangeSelector,b);this.destroy();this.init(a);this.render()};n.prototype.destroy=function(){var b=this,a=b.minInput,e=b.maxInput;b.eventsToUnbind&&(b.eventsToUnbind.forEach(function(b){return b()}),b.eventsToUnbind=void 0);c(b.buttons);a&&(a.onfocus=a.onblur=a.onchange=null);e&&(e.onfocus=e.onblur=e.onchange=null);H(b,function(a,c){a&&"chart"!==c&&(a instanceof l?a.destroy():a instanceof window.HTMLElement&&d(a));a!==n.prototype[c]&&(b[c]=null)},this)};return n}();
E.prototype.defaultButtons=[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}];E.prototype.inputTypeFormats={"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"};a.prototype.minFromRange=function(){var b=this.range,a=b.type,c=this.max,
d=this.chart.time,e=function(b,c){var e="year"===a?"FullYear":"Month",f=new d.Date(b),g=d.get(e,f);d.set(e,f,g+c);g===d.get(e,f)&&d.set("Date",f,0);return f.getTime()-b};if(u(b)){var f=c-b;var g=b}else f=c+e(c,-b.count),this.chart&&(this.chart.fixedRange=c-f);var k=A(this.dataMin,Number.MIN_VALUE);u(f)||(f=k);f<=k&&(f=k,"undefined"===typeof g&&(g=e(f,b.count)),this.newMax=Math.min(f+g,this.dataMax));u(c)||(f=void 0);return f};if(!p.RangeSelector){var D=[],F=function(b){function a(){d&&(c=b.xAxis[0].getExtremes(),
e=b.legend,g=d&&d.options.verticalAlign,u(c.min)&&d.render(c.min,c.max),e.display&&"top"===g&&g===e.options.verticalAlign&&(f=B(b.spacingBox),f.y="vertical"===e.options.layout?b.plotTop:f.y+d.getHeight(),e.group.placed=!1,e.align(f)))}var c,d=b.rangeSelector,e,f,g;d&&(r(D,function(a){return a[0]===b})||D.push([b,[k(b.xAxis[0],"afterSetExtremes",function(b){d&&d.render(b.min,b.max)}),k(b,"redraw",a)]]),a())};k(h,"afterGetContainer",function(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&
(this.rangeSelector=new E(this))});k(h,"beforeRender",function(){var b=this.axes,a=this.rangeSelector;a&&(u(a.deferredYTDClick)&&(a.clickButton(a.deferredYTDClick),delete a.deferredYTDClick),b.forEach(function(b){b.updateNames();b.setScale()}),this.getAxisMargins(),a.render(),b=a.options.verticalAlign,a.options.floating||("bottom"===b?this.extraBottomMargin=!0:"middle"!==b&&(this.extraTopMargin=!0)))});k(h,"update",function(a){var c=a.options.rangeSelector;a=this.rangeSelector;var d=this.extraBottomMargin,
e=this.extraTopMargin;c&&c.enabled&&!b(a)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=a=new E(this));this.extraTopMargin=this.extraBottomMargin=!1;a&&(F(this),c=c&&c.verticalAlign||a.options&&a.options.verticalAlign,a.options.floating||("bottom"===c?this.extraBottomMargin=!0:"middle"!==c&&(this.extraTopMargin=!0)),this.extraBottomMargin!==d||this.extraTopMargin!==e)&&(this.isDirtyBox=!0)});k(h,"render",function(){var b=this.rangeSelector;b&&!b.options.floating&&
(b.render(),b=b.options.verticalAlign,"bottom"===b?this.extraBottomMargin=!0:"middle"!==b&&(this.extraTopMargin=!0))});k(h,"getMargins",function(){var b=this.rangeSelector;b&&(b=b.getHeight(),this.extraTopMargin&&(this.plotTop+=b),this.extraBottomMargin&&(this.marginBottom+=b))});h.prototype.callbacks.push(F);k(h,"destroy",function(){for(var b=0;b<D.length;b++){var a=D[b];if(a[0]===this){a[1].forEach(function(b){return b()});D.splice(b,1);break}}});p.RangeSelector=E}return E});u(a,"Accessibility/Components/RangeSelectorComponent.js",
[a["Extensions/RangeSelector.js"],a["Accessibility/AccessibilityComponent.js"],a["Accessibility/Utils/ChartUtilities.js"],a["Accessibility/Utils/Announcer.js"],a["Core/Chart/Chart.js"],a["Accessibility/KeyboardNavigationHandler.js"],a["Core/Utilities.js"]],function(a,h,p,q,l,v,z){var m=p.unhideChartElementFromAT,k=p.getAxisRangeDescription,g=z.addEvent,f=z.attr;p=z.extend;l.prototype.highlightRangeSelectorButton=function(b){var a=this.rangeSelector&&this.rangeSelector.buttons||[],d=this.highlightedRangeSelectorItemIx,
e=this.rangeSelector&&this.rangeSelector.selected;"undefined"!==typeof d&&a[d]&&d!==e&&a[d].setState(this.oldRangeSelectorItemState||0);this.highlightedRangeSelectorItemIx=b;return a[b]?(this.setFocusToElement(a[b].box,a[b].element),b!==e&&(this.oldRangeSelectorItemState=a[b].state,a[b].setState(1)),!0):!1};g(a,"afterBtnClick",function(){if(this.chart.accessibility&&this.chart.accessibility.components.rangeSelector)return this.chart.accessibility.components.rangeSelector.onAfterBtnClick()});a=function(){};
a.prototype=new h;p(a.prototype,{init:function(){this.announcer=new q(this.chart,"polite")},onChartUpdate:function(){var b=this.chart,a=this,d=b.rangeSelector;d&&(this.updateSelectorVisibility(),this.setDropdownAttrs(),d.buttons&&d.buttons.length&&d.buttons.forEach(function(b){a.setRangeButtonAttrs(b)}),d.maxInput&&d.minInput&&["minInput","maxInput"].forEach(function(c,f){if(c=d[c])m(b,c),a.setRangeInputAttrs(c,"accessibility.rangeSelector."+(f?"max":"min")+"InputLabel")}))},updateSelectorVisibility:function(){var b=
this.chart,a=b.rangeSelector,d=a&&a.dropdown,e=a&&a.buttons||[];a&&a.hasVisibleDropdown&&d?(m(b,d),e.forEach(function(b){return b.element.setAttribute("aria-hidden",!0)})):(d&&d.setAttribute("aria-hidden",!0),e.forEach(function(a){return m(b,a.element)}))},setDropdownAttrs:function(){var b=this.chart,a=b.rangeSelector&&b.rangeSelector.dropdown;a&&(b=b.langFormat("accessibility.rangeSelector.dropdownLabel",{rangeTitle:b.options.lang.rangeSelectorZoom}),a.setAttribute("aria-label",b),a.setAttribute("tabindex",
-1))},setRangeButtonAttrs:function(b){f(b.element,{tabindex:-1,role:"button"})},setRangeInputAttrs:function(b,a){var c=this.chart;f(b,{tabindex:-1,"aria-label":c.langFormat(a,{chart:c})})},onButtonNavKbdArrowKey:function(b,a){var c=b.response,e=this.keyCodes,f=this.chart,g=f.options.accessibility.keyboardNavigation.wrapAround;a=a===e.left||a===e.up?-1:1;return f.highlightRangeSelectorButton(f.highlightedRangeSelectorItemIx+a)?c.success:g?(b.init(a),c.success):c[0<a?"next":"prev"]},onButtonNavKbdClick:function(b){b=
b.response;var a=this.chart;3!==a.oldRangeSelectorItemState&&this.fakeClickEvent(a.rangeSelector.buttons[a.highlightedRangeSelectorItemIx].element);return b.success},onAfterBtnClick:function(){var b=this.chart,a=k(b.xAxis[0]);(b=b.langFormat("accessibility.rangeSelector.clickButtonAnnouncement",{chart:b,axisRangeDescription:a}))&&this.announcer.announce(b)},onInputKbdMove:function(b){var a=this.chart,d=a.rangeSelector,e=a.highlightedInputRangeIx=(a.highlightedInputRangeIx||0)+b;1<e||0>e?a.accessibility&&
(a.accessibility.keyboardNavigation.tabindexContainer.focus(),a.accessibility.keyboardNavigation[0>b?"prev":"next"]()):d&&(b=d[e?"maxDateBox":"minDateBox"],d=d[e?"maxInput":"minInput"],b&&d&&a.setFocusToElement(b,d))},onInputNavInit:function(b){var a=this,d=this,e=this.chart,f=0<b?0:1,k=e.rangeSelector,h=k&&k[f?"maxDateBox":"minDateBox"];b=k&&k.minInput;k=k&&k.maxInput;e.highlightedInputRangeIx=f;if(h&&b&&k){e.setFocusToElement(h,f?k:b);this.removeInputKeydownHandler&&this.removeInputKeydownHandler();
e=function(b){(b.which||b.keyCode)===a.keyCodes.tab&&(b.preventDefault(),b.stopPropagation(),d.onInputKbdMove(b.shiftKey?-1:1))};var l=g(b,"keydown",e),m=g(k,"keydown",e);this.removeInputKeydownHandler=function(){l();m()}}},onInputNavTerminate:function(){var b=this.chart.rangeSelector||{};b.maxInput&&b.hideInput("max");b.minInput&&b.hideInput("min");this.removeInputKeydownHandler&&(this.removeInputKeydownHandler(),delete this.removeInputKeydownHandler)},initDropdownNav:function(){var b=this,a=this.chart,
d=a.rangeSelector,e=d&&d.dropdown;d&&e&&(a.setFocusToElement(d.buttonGroup,e),this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeDropdownKeydownHandler=g(e,"keydown",function(c){(c.which||c.keyCode)===b.keyCodes.tab&&(c.preventDefault(),c.stopPropagation(),a.accessibility&&(a.accessibility.keyboardNavigation.tabindexContainer.focus(),a.accessibility.keyboardNavigation[c.shiftKey?"prev":"next"]()))}))},getRangeSelectorButtonNavigation:function(){var b=this.chart,a=this.keyCodes,
d=this;return new v(b,{keyCodeMap:[[[a.left,a.right,a.up,a.down],function(b){return d.onButtonNavKbdArrowKey(this,b)}],[[a.enter,a.space],function(){return d.onButtonNavKbdClick(this)}]],validate:function(){return!!(b.rangeSelector&&b.rangeSelector.buttons&&b.rangeSelector.buttons.length)},init:function(a){var c=b.rangeSelector;c&&c.hasVisibleDropdown?d.initDropdownNav():c&&(c=c.buttons.length-1,b.highlightRangeSelectorButton(0<a?0:c))},terminate:function(){d.removeDropdownKeydownHandler&&(d.removeDropdownKeydownHandler(),
delete d.removeDropdownKeydownHandler)}})},getRangeSelectorInputNavigation:function(){var b=this.chart,a=this;return new v(b,{keyCodeMap:[],validate:function(){return!!(b.rangeSelector&&b.rangeSelector.inputGroup&&"hidden"!==b.rangeSelector.inputGroup.element.style.visibility&&!1!==b.options.rangeSelector.inputEnabled&&b.rangeSelector.minInput&&b.rangeSelector.maxInput)},init:function(b){a.onInputNavInit(b)},terminate:function(){a.onInputNavTerminate()}})},getKeyboardNavigation:function(){return[this.getRangeSelectorButtonNavigation(),
this.getRangeSelectorInputNavigation()]},destroy:function(){this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler();this.removeInputKeydownHandler&&this.removeInputKeydownHandler();this.announcer&&this.announcer.destroy()}});return a});u(a,"Accessibility/Components/SeriesComponent/ForcedMarkers.js",[a["Core/Utilities.js"]],function(a){var h=a.addEvent,m=a.merge,q;(function(a){function l(b){m(!0,b,{marker:{enabled:!0,states:{normal:{opacity:0}}}})}function p(b){return b.marker.states&&
b.marker.states.normal&&b.marker.states.normal.opacity}function q(){if(this.chart.styledMode){if(this.markerGroup)this.markerGroup[this.a11yMarkersForced?"addClass":"removeClass"]("highcharts-a11y-markers-hidden");this._hasPointMarkers&&this.points&&this.points.length&&this.points.forEach(function(b){b.graphic&&(b.graphic[b.hasForcedA11yMarker?"addClass":"removeClass"]("highcharts-a11y-marker-hidden"),b.graphic[!1===b.hasForcedA11yMarker?"addClass":"removeClass"]("highcharts-a11y-marker-visible"))})}}
function k(b){this.resetA11yMarkerOptions=m(b.options.marker||{},this.userOptions.marker||{})}function g(){var b=this.options,a=!1!==(this.options.accessibility&&this.options.accessibility.enabled);if(a=this.chart.options.accessibility.enabled&&a)a=this.chart.options.accessibility,a=this.points.length<a.series.pointDescriptionEnabledThreshold||!1===a.series.pointDescriptionEnabledThreshold;if(a){if(b.marker&&!1===b.marker.enabled&&(this.a11yMarkersForced=!0,l(this.options)),this._hasPointMarkers&&
this.points&&this.points.length)for(b=this.points.length;b--;){a=this.points[b];var d=a.options,e=a.hasForcedA11yMarker;delete a.hasForcedA11yMarker;d.marker&&(e=e&&0===p(d),d.marker.enabled&&!e?(m(!0,d.marker,{states:{normal:{opacity:p(d)||1}}}),a.hasForcedA11yMarker=!1):!1===d.marker.enabled&&(l(d),a.hasForcedA11yMarker=!0))}}else this.a11yMarkersForced&&(delete this.a11yMarkersForced,(b=this.resetA11yMarkerOptions)&&m(!0,this.options,{marker:{enabled:b.enabled,states:{normal:{opacity:b.states&&
b.states.normal&&b.states.normal.opacity}}}}))}var f=[];a.compose=function(b){-1===f.indexOf(b)&&(f.push(b),h(b,"afterSetOptions",k),h(b,"render",g),h(b,"afterRender",q))}})(q||(q={}));return q});u(a,"Accessibility/Components/SeriesComponent/SeriesKeyboardNavigation.js",[a["Core/Series/Point.js"],a["Core/Series/Series.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Globals.js"],a["Core/Utilities.js"],a["Accessibility/KeyboardNavigationHandler.js"],a["Accessibility/Utils/EventProvider.js"],a["Accessibility/Utils/ChartUtilities.js"]],
function(a,h,p,q,l,v,u,w){function k(b){var a=b.index,c=b.series.points,d=c.length;if(c[a]!==b)for(;d--;){if(c[d]===b)return d}else return a}function g(b){var a=b.chart.options.accessibility.keyboardNavigation.seriesNavigation,c=b.options.accessibility||{},d=c.keyboardNavigation;return d&&!1===d.enabled||!1===c.enabled||!1===b.options.enableMouseTracking||!b.visible||a.pointNavigationEnabledThreshold&&a.pointNavigationEnabledThreshold<=b.points.length}function f(b){var a=b.series.chart.options.accessibility,
c=b.options.accessibility&&!1===b.options.accessibility.enabled;return b.isNull&&a.keyboardNavigation.seriesNavigation.skipNullPoints||!1===b.visible||!1===b.isInside||c||g(b.series)}function b(b){var a=!1;delete b.highlightedPoint;return a=b.series.reduce(function(b,a){return b||a.highlightFirstValidPoint()},!1)}var c=p.seriesTypes,d=q.doc,e=l.defined,m=l.fireEvent,z=w.getPointFromXY,L=w.getSeriesFromName,B=w.scrollToPoint;p=function(){function c(b,a){this.keyCodes=a;this.chart=b}c.prototype.init=
function(){var c=this,e=this.chart,f=this.eventProvider=new u;f.addEvent(h,"destroy",function(){return c.onSeriesDestroy(this)});f.addEvent(e,"afterDrilldown",function(){b(this);this.focusElement&&this.focusElement.removeFocusBorder()});f.addEvent(e,"drilldown",function(b){b=b.point;var a=b.series;c.lastDrilledDownPoint={x:b.x,y:b.y,seriesName:a?a.name:""}});f.addEvent(e,"drillupall",function(){setTimeout(function(){c.onDrillupAll()},10)});f.addEvent(a,"afterSetState",function(){var b=this.graphic&&
this.graphic.element,a=d.activeElement,c=a&&a.getAttribute("class");c=c&&-1<c.indexOf("highcharts-a11y-proxy-button");e.highlightedPoint===this&&a!==b&&!c&&b&&b.focus&&b.focus()})};c.prototype.onDrillupAll=function(){var b=this.lastDrilledDownPoint,a=this.chart,c=b&&L(a,b.seriesName),d;b&&c&&e(b.x)&&e(b.y)&&(d=z(c,b.x,b.y));a.container&&a.container.focus();d&&d.highlight&&d.highlight();a.focusElement&&a.focusElement.removeFocusBorder()};c.prototype.getKeyboardNavigationHandler=function(){var a=this,
c=this.keyCodes,d=this.chart,e=d.inverted;return new v(d,{keyCodeMap:[[e?[c.up,c.down]:[c.left,c.right],function(b){return a.onKbdSideways(this,b)}],[e?[c.left,c.right]:[c.up,c.down],function(b){return a.onKbdVertical(this,b)}],[[c.enter,c.space],function(b,a){if(b=d.highlightedPoint)a.point=b,m(b.series,"click",a),b.firePointEvent("click");return this.response.success}],[[c.home],function(){b(d);return this.response.success}],[[c.end],function(){for(var b=d.series.length,a;b--&&!(d.highlightedPoint=
d.series[b].points[d.series[b].points.length-1],a=d.series[b].highlightFirstValidPoint()););return this.response.success}],[[c.pageDown,c.pageUp],function(b){d.highlightAdjacentSeries(b===c.pageDown);return this.response.success}]],init:function(){b(d);return this.response.success},terminate:function(){return a.onHandlerTerminate()}})};c.prototype.onKbdSideways=function(b,a){var c=this.keyCodes;return this.attemptHighlightAdjacentPoint(b,a===c.right||a===c.down)};c.prototype.onKbdVertical=function(b,
a){var c=this.chart,d=this.keyCodes;a=a===d.down||a===d.right;d=c.options.accessibility.keyboardNavigation.seriesNavigation;if(d.mode&&"serialize"===d.mode)return this.attemptHighlightAdjacentPoint(b,a);c[c.highlightedPoint&&c.highlightedPoint.series.keyboardMoveVertical?"highlightAdjacentPointVertical":"highlightAdjacentSeries"](a);return b.response.success};c.prototype.onHandlerTerminate=function(){var b=this.chart;b.tooltip&&b.tooltip.hide(0);var a=b.highlightedPoint&&b.highlightedPoint.series;
if(a&&a.onMouseOut)a.onMouseOut();if(b.highlightedPoint&&b.highlightedPoint.onMouseOut)b.highlightedPoint.onMouseOut();delete b.highlightedPoint};c.prototype.attemptHighlightAdjacentPoint=function(b,a){var c=this.chart,d=c.options.accessibility.keyboardNavigation.wrapAround;return c.highlightAdjacentPoint(a)?b.response.success:d?b.init(a?1:-1):b.response[a?"next":"prev"]};c.prototype.onSeriesDestroy=function(b){var a=this.chart;a.highlightedPoint&&a.highlightedPoint.series===b&&(delete a.highlightedPoint,
a.focusElement&&a.focusElement.removeFocusBorder())};c.prototype.destroy=function(){this.eventProvider.removeAddedEvents()};return c}();(function(b){function a(b){var a=this.series,c=this.highlightedPoint,d=c&&k(c)||0,e=c&&c.series.points||[],h=this.series&&this.series[this.series.length-1];h=h&&h.points&&h.points[h.points.length-1];if(!a[0]||!a[0].points)return!1;if(c){if(a=a[c.series.index+(b?1:-1)],d=e[d+(b?1:-1)],!d&&a&&(d=a.points[b?0:a.points.length-1]),!d)return!1}else d=b?a[0].points[0]:h;
return f(d)?(a=d.series,g(a)?this.highlightedPoint=b?a.points[a.points.length-1]:a.points[0]:this.highlightedPoint=d,this.highlightAdjacentPoint(b)):d.highlight()}function d(b){var a=this.highlightedPoint,c=Infinity,d;if(!e(a.plotX)||!e(a.plotY))return!1;this.series.forEach(function(k){g(k)||k.points.forEach(function(g){if(e(g.plotY)&&e(g.plotX)&&g!==a){var h=g.plotY-a.plotY,l=Math.abs(g.plotX-a.plotX);l=Math.abs(h)*Math.abs(h)+l*l*4;k.yAxis&&k.yAxis.reversed&&(h*=-1);!(0>=h&&b||0<=h&&!b||5>l||f(g))&&
l<c&&(c=l,d=g)}})});return d?d.highlight():!1}function h(b){var a=this.highlightedPoint,c=this.series&&this.series[this.series.length-1],d=c&&c.points&&c.points[c.points.length-1];if(!this.highlightedPoint)return c=b?this.series&&this.series[0]:c,(d=b?c&&c.points&&c.points[0]:d)?d.highlight():!1;c=this.series[a.series.index+(b?-1:1)];if(!c)return!1;d=l(a,c,4);if(!d)return!1;if(g(c))return d.highlight(),b=this.highlightAdjacentSeries(b),b?b:(a.highlight(),!1);d.highlight();return d.series.highlightFirstValidPoint()}
function l(b,a,c,d){var f=Infinity,g=a.points.length,k=function(b){return!(e(b.plotX)&&e(b.plotY))};if(!k(b)){for(;g--;){var h=a.points[g];if(!k(h)&&(h=(b.plotX-h.plotX)*(b.plotX-h.plotX)*(c||1)+(b.plotY-h.plotY)*(b.plotY-h.plotY)*(d||1),h<f)){f=h;var l=g}}return e(l)?a.points[l]:void 0}}function m(){var b=this.series.chart;if(this.isNull)b.tooltip&&b.tooltip.hide(0);else this.onMouseOver();B(this);this.graphic&&b.setFocusToElement(this.graphic);b.highlightedPoint=this;return this}function r(){var b=
this.chart.highlightedPoint,a=(b&&b.series)===this?k(b):0;b=this.points;var c=b.length;if(b&&c){for(var d=a;d<c;++d)if(!f(b[d]))return b[d].highlight();for(;0<=a;--a)if(!f(b[a]))return b[a].highlight()}return!1}var p=[];b.compose=function(b,e,f){-1===p.indexOf(b)&&(p.push(b),b=b.prototype,b.highlightAdjacentPoint=a,b.highlightAdjacentPointVertical=d,b.highlightAdjacentSeries=h);-1===p.indexOf(e)&&(p.push(e),e.prototype.highlight=m);-1===p.indexOf(f)&&(p.push(f),e=f.prototype,e.keyboardMoveVertical=
!0,["column","gantt","pie"].forEach(function(b){c[b]&&(c[b].prototype.keyboardMoveVertical=!1)}),e.highlightFirstValidPoint=r)}})(p||(p={}));return p});u(a,"Accessibility/Components/SeriesComponent/SeriesComponent.js",[a["Accessibility/AccessibilityComponent.js"],a["Accessibility/Utils/ChartUtilities.js"],a["Accessibility/Components/SeriesComponent/ForcedMarkers.js"],a["Accessibility/Components/SeriesComponent/NewDataAnnouncer.js"],a["Accessibility/Components/SeriesComponent/SeriesDescriber.js"],
a["Accessibility/Components/SeriesComponent/SeriesKeyboardNavigation.js"],a["Core/Tooltip.js"]],function(a,h,p,q,l,v,u){var m=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,a){b.__proto__=a}||function(b,a){for(var c in a)a.hasOwnProperty(c)&&(b[c]=a[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),k=h.hideSeriesFromAT,g=
l.describeSeries;return function(a){function b(){return null!==a&&a.apply(this,arguments)||this}m(b,a);b.compose=function(b,a,e){p.compose(e);v.compose(b,a,e)};b.prototype.init=function(){this.newDataAnnouncer=new q(this.chart);this.newDataAnnouncer.init();this.keyboardNavigation=new v(this.chart,this.keyCodes);this.keyboardNavigation.init();this.hideTooltipFromATWhenShown();this.hideSeriesLabelsFromATWhenShown()};b.prototype.hideTooltipFromATWhenShown=function(){var b=this;this.addEvent(u,"refresh",
function(){this.chart===b.chart&&this.label&&this.label.element&&this.label.element.setAttribute("aria-hidden",!0)})};b.prototype.hideSeriesLabelsFromATWhenShown=function(){this.addEvent(this.chart,"afterDrawSeriesLabels",function(){this.series.forEach(function(b){b.labelBySeries&&b.labelBySeries.attr("aria-hidden",!0)})})};b.prototype.onChartRender=function(){this.chart.series.forEach(function(b){!1!==(b.options.accessibility&&b.options.accessibility.enabled)&&b.visible?g(b):k(b)})};b.prototype.getKeyboardNavigation=
function(){return this.keyboardNavigation.getKeyboardNavigationHandler()};b.prototype.destroy=function(){this.newDataAnnouncer.destroy();this.keyboardNavigation.destroy()};return b}(a)});u(a,"Accessibility/Components/ZoomComponent.js",[a["Accessibility/AccessibilityComponent.js"],a["Accessibility/Utils/ChartUtilities.js"],a["Core/Globals.js"],a["Accessibility/KeyboardNavigationHandler.js"],a["Core/Utilities.js"]],function(a,h,p,q,l){var m=h.unhideChartElementFromAT;h=p.noop;var u=l.attr,w=l.extend,
k=l.pick;p.Axis.prototype.panStep=function(a,f){var b=f||3;f=this.getExtremes();var c=(f.max-f.min)/b*a;b=f.max+c;c=f.min+c;var d=b-c;0>a&&c<f.dataMin?(c=f.dataMin,b=c+d):0<a&&b>f.dataMax&&(b=f.dataMax,c=b-d);this.setExtremes(c,b)};h.prototype=new a;w(h.prototype,{init:function(){var a=this,f=this.chart;this.proxyProvider.addGroup("zoom","div");["afterShowResetZoom","afterDrilldown","drillupall"].forEach(function(b){a.addEvent(f,b,function(){a.updateProxyOverlays()})})},onChartUpdate:function(){var a=
this.chart,f=this;a.mapNavButtons&&a.mapNavButtons.forEach(function(b,c){m(a,b.element);f.setMapNavButtonAttrs(b.element,"accessibility.zoom.mapZoom"+(c?"Out":"In"))})},setMapNavButtonAttrs:function(a,f){var b=this.chart;f=b.langFormat(f,{chart:b});u(a,{tabindex:-1,role:"button","aria-label":f})},onChartRender:function(){this.updateProxyOverlays()},updateProxyOverlays:function(){var a=this.chart;this.proxyProvider.clearGroup("zoom");a.resetZoomButton&&this.createZoomProxyButton(a.resetZoomButton,
"resetZoomProxyButton",a.langFormat("accessibility.zoom.resetZoomButton",{chart:a}));a.drillUpButton&&this.createZoomProxyButton(a.drillUpButton,"drillUpProxyButton",a.langFormat("accessibility.drillUpButton",{chart:a,buttonText:a.getDrilldownBackText()}))},createZoomProxyButton:function(a,f,b){this[f]=this.proxyProvider.addProxyElement("zoom",{click:a},{"aria-label":b,tabindex:-1})},getMapZoomNavigation:function(){var a=this.keyCodes,f=this.chart,b=this;return new q(f,{keyCodeMap:[[[a.up,a.down,
a.left,a.right],function(a){return b.onMapKbdArrow(this,a)}],[[a.tab],function(a,d){return b.onMapKbdTab(this,d)}],[[a.space,a.enter],function(){return b.onMapKbdClick(this)}]],validate:function(){return!!(f.mapZoom&&f.mapNavButtons&&f.mapNavButtons.length)},init:function(a){return b.onMapNavInit(a)}})},onMapKbdArrow:function(a,f){var b=this.keyCodes;this.chart[f===b.up||f===b.down?"yAxis":"xAxis"][0].panStep(f===b.left||f===b.up?-1:1);return a.response.success},onMapKbdTab:function(a,f){var b=this.chart;
a=a.response;var c=(f=f.shiftKey)&&!this.focusedMapNavButtonIx||!f&&this.focusedMapNavButtonIx;b.mapNavButtons[this.focusedMapNavButtonIx].setState(0);if(c)return b.mapZoom(),a[f?"prev":"next"];this.focusedMapNavButtonIx+=f?-1:1;f=b.mapNavButtons[this.focusedMapNavButtonIx];b.setFocusToElement(f.box,f.element);f.setState(2);return a.success},onMapKbdClick:function(a){this.fakeClickEvent(this.chart.mapNavButtons[this.focusedMapNavButtonIx].element);return a.response.success},onMapNavInit:function(a){var f=
this.chart,b=f.mapNavButtons[0],c=f.mapNavButtons[1];b=0<a?b:c;f.setFocusToElement(b.box,b.element);b.setState(2);this.focusedMapNavButtonIx=0<a?0:1},simpleButtonNavigation:function(a,f,b){var c=this.keyCodes,d=this,e=this.chart;return new q(e,{keyCodeMap:[[[c.tab,c.up,c.down,c.left,c.right],function(a,b){return this.response[a===c.tab&&b.shiftKey||a===c.left||a===c.up?"prev":"next"]}],[[c.space,c.enter],function(){var a=b(this,e);return k(a,this.response.success)}]],validate:function(){return e[a]&&
e[a].box&&d[f].buttonElement},init:function(){e.setFocusToElement(e[a].box,d[f].buttonElement)}})},getKeyboardNavigation:function(){return[this.simpleButtonNavigation("resetZoomButton","resetZoomProxyButton",function(a,f){f.zoomOut()}),this.simpleButtonNavigation("drillUpButton","drillUpProxyButton",function(a,f){f.drillUp();return a.response.prev}),this.getMapZoomNavigation()]}});return h});u(a,"Accessibility/HighContrastMode.js",[a["Core/Globals.js"]],function(a){var h=a.doc,m=a.isMS,q=a.win;return{isHighContrastModeActive:function(){var a=
/(Edg)/.test(q.navigator.userAgent);if(q.matchMedia&&a)return q.matchMedia("(-ms-high-contrast: active)").matches;if(m&&q.getComputedStyle){a=h.createElement("div");a.style.backgroundImage="url(data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==)";h.body.appendChild(a);var p=(a.currentStyle||q.getComputedStyle(a)).backgroundImage;h.body.removeChild(a);return"none"===p}return!1},setHighContrastTheme:function(a){a.highContrastModeActive=!0;var h=a.options.accessibility.highContrastTheme;
a.update(h,!1);a.series.forEach(function(a){var l=h.plotOptions[a.type]||{};a.update({color:l.color||"windowText",colors:[l.color||"windowText"],borderColor:l.borderColor||"window"});a.points.forEach(function(a){a.options&&a.options.color&&a.update({color:l.color||"windowText",borderColor:l.borderColor||"window"},!1)})});a.redraw()}}});u(a,"Accessibility/HighContrastTheme.js",[],function(){return{chart:{backgroundColor:"window"},title:{style:{color:"windowText"}},subtitle:{style:{color:"windowText"}},
colorAxis:{minColor:"windowText",maxColor:"windowText",stops:[]},colors:["windowText"],xAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},yAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},tooltip:{backgroundColor:"window",borderColor:"windowText",
style:{color:"windowText"}},plotOptions:{series:{lineColor:"windowText",fillColor:"window",borderColor:"windowText",edgeColor:"windowText",borderWidth:1,dataLabels:{connectorColor:"windowText",color:"windowText",style:{color:"windowText",textOutline:"none"}},marker:{lineColor:"windowText",fillColor:"windowText"}},pie:{color:"window",colors:["window"],borderColor:"windowText",borderWidth:1},boxplot:{fillColor:"window"},candlestick:{lineColor:"windowText",fillColor:"window"},errorbar:{fillColor:"window"}},
legend:{backgroundColor:"window",itemStyle:{color:"windowText"},itemHoverStyle:{color:"windowText"},itemHiddenStyle:{color:"#555"},title:{style:{color:"windowText"}}},credits:{style:{color:"windowText"}},labels:{style:{color:"windowText"}},drilldown:{activeAxisLabelStyle:{color:"windowText"},activeDataLabelStyle:{color:"windowText"}},navigation:{buttonOptions:{symbolStroke:"windowText",theme:{fill:"window"}}},rangeSelector:{buttonTheme:{fill:"window",stroke:"windowText",style:{color:"windowText"},
states:{hover:{fill:"window",stroke:"windowText",style:{color:"windowText"}},select:{fill:"#444",stroke:"windowText",style:{color:"windowText"}}}},inputBoxBorderColor:"windowText",inputStyle:{backgroundColor:"window",color:"windowText"},labelStyle:{color:"windowText"}},navigator:{handles:{backgroundColor:"window",borderColor:"windowText"},outlineColor:"windowText",maskFill:"transparent",series:{color:"windowText",lineColor:"windowText"},xAxis:{gridLineColor:"windowText"}},scrollbar:{barBackgroundColor:"#444",
barBorderColor:"windowText",buttonArrowColor:"windowText",buttonBackgroundColor:"window",buttonBorderColor:"windowText",rifleColor:"windowText",trackBackgroundColor:"window",trackBorderColor:"windowText"}}});u(a,"Accessibility/Options/Options.js",[],function(){return{accessibility:{enabled:!0,screenReaderSection:{beforeChartFormat:"<{headingTagName}>{chartTitle}</{headingTagName}><div>{typeDescription}</div><div>{chartSubtitle}</div><div>{chartLongdesc}</div><div>{playAsSoundButton}</div><div>{viewTableButton}</div><div>{xAxisDescription}</div><div>{yAxisDescription}</div><div>{annotationsTitle}{annotationsList}</div>",
afterChartFormat:"{endOfChartMarker}",axisRangeDateFormat:"%Y-%m-%d %H:%M:%S"},series:{describeSingleSeries:!1,pointDescriptionEnabledThreshold:200},point:{valueDescriptionFormat:"{index}. {xDescription}{separator}{value}."},landmarkVerbosity:"all",linkedDescription:'*[data-highcharts-chart="{index}"] + .highcharts-description',keyboardNavigation:{enabled:!0,focusBorder:{enabled:!0,hideBrowserFocusOutline:!0,style:{color:"#335cad",lineWidth:2,borderRadius:3},margin:2},order:["series","zoom","rangeSelector",
"legend","chartMenu"],wrapAround:!0,seriesNavigation:{skipNullPoints:!0,pointNavigationEnabledThreshold:!1}},announceNewData:{enabled:!1,minAnnounceInterval:5E3,interruptUser:!1}},legend:{accessibility:{enabled:!0,keyboardNavigation:{enabled:!0}}},exporting:{accessibility:{enabled:!0}}}});u(a,"Accessibility/Options/LangOptions.js",[],function(){return{accessibility:{defaultChartTitle:"Chart",chartContainerLabel:"{title}. Highcharts interactive chart.",svgContainerLabel:"Interactive chart",drillUpButton:"{buttonText}",
credits:"Chart credits: {creditsStr}",thousandsSep:",",svgContainerTitle:"",graphicContainerLabel:"",screenReaderSection:{beforeRegionLabel:"Chart screen reader information, {chartTitle}.",afterRegionLabel:"",annotations:{heading:"Chart annotations summary",descriptionSinglePoint:"{annotationText}. Related to {annotationPoint}",descriptionMultiplePoints:"{annotationText}. Related to {annotationPoint}{ Also related to, #each(additionalAnnotationPoints)}",descriptionNoPoints:"{annotationText}"},endOfChartMarker:"End of interactive chart."},
sonification:{playAsSoundButtonText:"Play as sound, {chartTitle}",playAsSoundClickAnnouncement:"Play"},legend:{legendLabelNoTitle:"Toggle series visibility, {chartTitle}",legendLabel:"Chart legend: {legendTitle}",legendItem:"Show {itemName}"},zoom:{mapZoomIn:"Zoom chart",mapZoomOut:"Zoom out chart",resetZoomButton:"Reset zoom"},rangeSelector:{dropdownLabel:"{rangeTitle}",minInputLabel:"Select start date.",maxInputLabel:"Select end date.",clickButtonAnnouncement:"Viewing {axisRangeDescription}"},table:{viewAsDataTableButtonText:"View as data table, {chartTitle}",
tableSummary:"Table representation of chart."},announceNewData:{newDataAnnounce:"Updated data for chart {chartTitle}",newSeriesAnnounceSingle:"New data series: {seriesDesc}",newPointAnnounceSingle:"New data point: {pointDesc}",newSeriesAnnounceMultiple:"New data series in chart {chartTitle}: {seriesDesc}",newPointAnnounceMultiple:"New data point in chart {chartTitle}: {pointDesc}"},seriesTypeDescriptions:{boxplot:"Box plot charts are typically used to display groups of statistical data. Each data point in the chart can have up to 5 values: minimum, lower quartile, median, upper quartile, and maximum.",
arearange:"Arearange charts are line charts displaying a range between a lower and higher value for each point.",areasplinerange:"These charts are line charts displaying a range between a lower and higher value for each point.",bubble:"Bubble charts are scatter charts where each data point also has a size value.",columnrange:"Columnrange charts are column charts displaying a range between a lower and higher value for each point.",errorbar:"Errorbar series are used to display the variability of the data.",
funnel:"Funnel charts are used to display reduction of data in stages.",pyramid:"Pyramid charts consist of a single pyramid with item heights corresponding to each point value.",waterfall:"A waterfall chart is a column chart where each column contributes towards a total end value."},chartTypes:{emptyChart:"Empty chart",mapTypeDescription:"Map of {mapTitle} with {numSeries} data series.",unknownMap:"Map of unspecified region with {numSeries} data series.",combinationChart:"Combination chart with {numSeries} data series.",
defaultSingle:"Chart with {numPoints} data {#plural(numPoints, points, point)}.",defaultMultiple:"Chart with {numSeries} data series.",splineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",splineMultiple:"Line chart with {numSeries} lines.",lineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",lineMultiple:"Line chart with {numSeries} lines.",columnSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",columnMultiple:"Bar chart with {numSeries} data series.",
barSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",barMultiple:"Bar chart with {numSeries} data series.",pieSingle:"Pie chart with {numPoints} {#plural(numPoints, slices, slice)}.",pieMultiple:"Pie chart with {numSeries} pies.",scatterSingle:"Scatter chart with {numPoints} {#plural(numPoints, points, point)}.",scatterMultiple:"Scatter chart with {numSeries} data series.",boxplotSingle:"Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotMultiple:"Boxplot with {numSeries} data series.",
bubbleSingle:"Bubble chart with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleMultiple:"Bubble chart with {numSeries} data series."},axis:{xAxisDescriptionSingular:"The chart has 1 X axis displaying {names[0]}. {ranges[0]}",xAxisDescriptionPlural:"The chart has {numAxes} X axes displaying {#each(names, -1) }and {names[-1]}.",yAxisDescriptionSingular:"The chart has 1 Y axis displaying {names[0]}. {ranges[0]}",yAxisDescriptionPlural:"The chart has {numAxes} Y axes displaying {#each(names, -1) }and {names[-1]}.",
timeRangeDays:"Range: {range} days.",timeRangeHours:"Range: {range} hours.",timeRangeMinutes:"Range: {range} minutes.",timeRangeSeconds:"Range: {range} seconds.",rangeFromTo:"Range: {rangeFrom} to {rangeTo}.",rangeCategories:"Range: {numCategories} categories."},exporting:{chartMenuLabel:"Chart menu",menuButtonLabel:"View chart menu, {chartTitle}"},series:{summary:{"default":"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",defaultCombination:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",
line:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",lineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",spline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",splineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",column:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",
columnCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",bar:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",barCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",pie:"{name}, pie {ix} of {numSeries} with {numPoints} {#plural(numPoints, slices, slice)}.",pieCombination:"{name}, series {ix} of {numSeries}. Pie with {numPoints} {#plural(numPoints, slices, slice)}.",
scatter:"{name}, scatter plot {ix} of {numSeries} with {numPoints} {#plural(numPoints, points, point)}.",scatterCombination:"{name}, series {ix} of {numSeries}, scatter plot with {numPoints} {#plural(numPoints, points, point)}.",boxplot:"{name}, boxplot {ix} of {numSeries} with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotCombination:"{name}, series {ix} of {numSeries}. Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",bubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",
bubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}.",map:"{name}, map {ix} of {numSeries} with {numPoints} {#plural(numPoints, areas, area)}.",mapCombination:"{name}, series {ix} of {numSeries}. Map with {numPoints} {#plural(numPoints, areas, area)}.",mapline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",maplineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",
mapbubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",mapbubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}."},description:"{description}",xAxisDescription:"X axis, {name}",yAxisDescription:"Y axis, {name}",nullPointValue:"No value",pointAnnotationsDescription:"{Annotation: #each(annotations). }"}}}});u(a,"Accessibility/Options/DeprecatedOptions.js",[a["Core/Utilities.js"]],
function(a){function h(a,g,f){for(var b,c=0;c<g.length-1;++c)b=g[c],a=a[b]=w(a[b],{});a[g[g.length-1]]=f}function m(a,g,f,b){function c(a,b){return b.reduce(function(a,b){return a[b]},a)}var d=c(a.options,g),e=c(a.options,f);Object.keys(b).forEach(function(c){var k,l=d[c];"undefined"!==typeof l&&(h(e,b[c],l),u(32,!1,a,(k={},k[g.join(".")+"."+c]=f.join(".")+"."+b[c].join("."),k)))})}function q(a){var g=a.options.chart,f=a.options.accessibility||{};["description","typeDescription"].forEach(function(b){var c;
g[b]&&(f[b]=g[b],u(32,!1,a,(c={},c["chart."+b]="use accessibility."+b,c)))})}function l(a){a.axes.forEach(function(g){(g=g.options)&&g.description&&(g.accessibility=g.accessibility||{},g.accessibility.description=g.description,u(32,!1,a,{"axis.description":"use axis.accessibility.description"}))})}function v(a){var g={description:["accessibility","description"],exposeElementToA11y:["accessibility","exposeAsGroupOnly"],pointDescriptionFormatter:["accessibility","point","descriptionFormatter"],skipKeyboardNavigation:["accessibility",
"keyboardNavigation","enabled"],"accessibility.pointDescriptionFormatter":["accessibility","point","descriptionFormatter"]};a.series.forEach(function(f){Object.keys(g).forEach(function(b){var c,d=f.options[b];"accessibility.pointDescriptionFormatter"===b&&(d=f.options.accessibility&&f.options.accessibility.pointDescriptionFormatter);"undefined"!==typeof d&&(h(f.options,g[b],"skipKeyboardNavigation"===b?!d:d),u(32,!1,a,(c={},c["series."+b]="series."+g[b].join("."),c)))})})}var u=a.error,w=a.pick;return function(a){q(a);
l(a);a.series&&v(a);m(a,["accessibility"],["accessibility"],{pointDateFormat:["point","dateFormat"],pointDateFormatter:["point","dateFormatter"],pointDescriptionFormatter:["point","descriptionFormatter"],pointDescriptionThreshold:["series","pointDescriptionEnabledThreshold"],pointNavigationThreshold:["keyboardNavigation","seriesNavigation","pointNavigationEnabledThreshold"],pointValueDecimals:["point","valueDecimals"],pointValuePrefix:["point","valuePrefix"],pointValueSuffix:["point","valueSuffix"],
screenReaderSectionFormatter:["screenReaderSection","beforeChartFormatter"],describeSingleSeries:["series","describeSingleSeries"],seriesDescriptionFormatter:["series","descriptionFormatter"],onTableAnchorClick:["screenReaderSection","onViewDataTableClick"],axisRangeDateFormat:["screenReaderSection","axisRangeDateFormat"]});m(a,["accessibility","keyboardNavigation"],["accessibility","keyboardNavigation","seriesNavigation"],{skipNullPoints:["skipNullPoints"],mode:["mode"]});m(a,["lang","accessibility"],
["lang","accessibility"],{legendItem:["legend","legendItem"],legendLabel:["legend","legendLabel"],mapZoomIn:["zoom","mapZoomIn"],mapZoomOut:["zoom","mapZoomOut"],resetZoomButton:["zoom","resetZoomButton"],screenReaderRegionLabel:["screenReaderSection","beforeRegionLabel"],rangeSelectorButton:["rangeSelector","buttonText"],rangeSelectorMaxInput:["rangeSelector","maxInputLabel"],rangeSelectorMinInput:["rangeSelector","minInputLabel"],svgContainerEnd:["screenReaderSection","endOfChartMarker"],viewAsDataTable:["table",
"viewAsDataTableButtonText"],tableSummary:["table","tableSummary"]})}});u(a,"Accessibility/Accessibility.js",[a["Core/DefaultOptions.js"],a["Core/Globals.js"],a["Core/Utilities.js"],a["Accessibility/A11yI18n.js"],a["Accessibility/Components/ContainerComponent.js"],a["Accessibility/FocusBorder.js"],a["Accessibility/Components/InfoRegionsComponent.js"],a["Accessibility/KeyboardNavigation.js"],a["Accessibility/Components/LegendComponent.js"],a["Accessibility/Components/MenuComponent.js"],a["Accessibility/Components/SeriesComponent/NewDataAnnouncer.js"],
a["Accessibility/ProxyProvider.js"],a["Accessibility/Components/RangeSelectorComponent.js"],a["Accessibility/Components/SeriesComponent/SeriesComponent.js"],a["Accessibility/Components/ZoomComponent.js"],a["Accessibility/HighContrastMode.js"],a["Accessibility/HighContrastTheme.js"],a["Accessibility/Options/Options.js"],a["Accessibility/Options/LangOptions.js"],a["Accessibility/Options/DeprecatedOptions.js"]],function(a,h,p,q,l,u,z,w,k,g,f,b,c,d,e,r,C,L,B,H){a=a.defaultOptions;var m=h.doc,v=p.addEvent,
I=p.extend,G=p.fireEvent,E=p.merge;h=function(){function a(a){this.proxyProvider=this.keyboardNavigation=this.components=this.chart=void 0;this.init(a)}a.prototype.init=function(a){this.chart=a;m.addEventListener&&a.renderer.isSVG?(H(a),this.proxyProvider=new b(this.chart),this.initComponents(),this.keyboardNavigation=new w(a,this.components),this.update()):(this.zombie=!0,this.components={},a.renderTo.setAttribute("aria-hidden",!0))};a.prototype.initComponents=function(){var a=this.chart,b=this.proxyProvider,
f=a.options.accessibility;this.components={container:new l,infoRegions:new z,legend:new k,chartMenu:new g,rangeSelector:new c,series:new d,zoom:new e};f.customComponents&&I(this.components,f.customComponents);var h=this.components;this.getComponentOrder().forEach(function(c){h[c].initBase(a,b);h[c].init()})};a.prototype.getComponentOrder=function(){if(!this.components)return[];if(!this.components.series)return Object.keys(this.components);var a=Object.keys(this.components).filter(function(a){return"series"!==
a});return["series"].concat(a)};a.prototype.update=function(){var a=this.components,b=this.chart,c=b.options.accessibility;G(b,"beforeA11yUpdate");b.types=this.getChartTypes();c=c.keyboardNavigation.order;this.proxyProvider.updateGroupOrder(c);this.getComponentOrder().forEach(function(c){a[c].onChartUpdate();G(b,"afterA11yComponentUpdate",{name:c,component:a[c]})});this.keyboardNavigation.update(c);!b.highContrastModeActive&&r.isHighContrastModeActive()&&r.setHighContrastTheme(b);G(b,"afterA11yUpdate",
{accessibility:this})};a.prototype.destroy=function(){var a=this.chart||{},b=this.components;Object.keys(b).forEach(function(a){b[a].destroy();b[a].destroyBase()});this.proxyProvider&&this.proxyProvider.destroy();this.keyboardNavigation&&this.keyboardNavigation.destroy();a.renderTo&&a.renderTo.setAttribute("aria-hidden",!0);a.focusElement&&a.focusElement.removeFocusBorder()};a.prototype.getChartTypes=function(){var a={};this.chart.series.forEach(function(b){a[b.type]=1});return Object.keys(a)};return a}();
(function(a){function b(){this.accessibility&&this.accessibility.destroy()}function c(){this.a11yDirty&&this.renderTo&&(delete this.a11yDirty,this.updateA11yEnabled());var a=this.accessibility;a&&!a.zombie&&(a.proxyProvider.updateProxyElementPositions(),a.getComponentOrder().forEach(function(b){a.components[b].onChartRender()}))}function e(a){if(a=a.options.accessibility)a.customComponents&&(this.options.accessibility.customComponents=a.customComponents,delete a.customComponents),E(!0,this.options.accessibility,
a),this.accessibility&&this.accessibility.destroy&&(this.accessibility.destroy(),delete this.accessibility);this.a11yDirty=!0}function g(){var b=this.accessibility,c=this.options.accessibility;c&&c.enabled?b&&!b.zombie?b.update():this.accessibility=new a(this):b?(b.destroy&&b.destroy(),delete this.accessibility):this.renderTo.setAttribute("aria-hidden",!0)}function h(){this.series.chart.accessibility&&(this.series.chart.a11yDirty=!0)}var k=[];a.i18nFormat=q.i18nFormat;a.compose=function(a,l,m,n){q.compose(a);
u.compose(a,n);w.compose(a);f.compose(m);d.compose(a,l,m);-1===k.indexOf(a)&&(k.push(a),a.prototype.updateA11yEnabled=g,v(a,"destroy",b),v(a,"render",c),v(a,"update",e),["addSeries","init"].forEach(function(b){v(a,b,function(){this.a11yDirty=!0})}),["afterDrilldown","drillupall"].forEach(function(b){v(a,b,function(){var a=this.accessibility;a&&!a.zombie&&a.update()})}));-1===k.indexOf(l)&&(k.push(l),v(l,"update",h));-1===k.indexOf(m)&&(k.push(m),["update","updatedData","remove"].forEach(function(a){v(m,
a,function(){this.chart.accessibility&&(this.chart.a11yDirty=!0)})}))}})(h||(h={}));E(!0,a,L,{accessibility:{highContrastTheme:C},lang:B});return h});u(a,"masters/modules/accessibility.src.js",[a["Core/Globals.js"],a["Accessibility/Accessibility.js"],a["Accessibility/AccessibilityComponent.js"],a["Accessibility/Utils/ChartUtilities.js"],a["Accessibility/Utils/HTMLUtilities.js"],a["Accessibility/KeyboardNavigationHandler.js"],a["Accessibility/Components/SeriesComponent/SeriesDescriber.js"]],function(a,
h,p,q,l,v,u){a.i18nFormat=h.i18nFormat;a.A11yChartUtilities=q;a.A11yHTMLUtilities=l;a.AccessibilityComponent=p;a.KeyboardNavigationHandler=v;a.SeriesAccessibilityDescriber=u;h.compose(a.Chart,a.Point,a.Series,a.SVGElement)})});
//# sourceMappingURL=accessibility.js.map